/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers.api.util;

import com.google.common.base.Preconditions;
import com.nisovin.shopkeepers.api.internal.util.Unsafe;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ChunkCoords {
    private @UnknownKeyFor @NonNull @Initialized String worldName;
    private @UnknownKeyFor @NonNull @Initialized int chunkX;
    private @UnknownKeyFor @NonNull @Initialized int chunkZ;

    public static @UnknownKeyFor @NonNull @Initialized int fromBlock(@UnknownKeyFor @NonNull @Initialized int blockCoord) {
        return blockCoord >> 4;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isSameChunk(@Nullable @UnknownKeyFor @Initialized Location location1, @Nullable @UnknownKeyFor @Initialized Location location2) {
        int chunkZ2;
        int chunkX2;
        if (location1 == null || location2 == null) {
            return false;
        }
        World world1 = location1.getWorld();
        World world2 = location2.getWorld();
        if (world1 == null || world2 == null) {
            return false;
        }
        if (!world1.getName().equals(world2.getName())) {
            return false;
        }
        int chunkX1 = ChunkCoords.fromBlock(location1.getBlockX());
        if (chunkX1 != (chunkX2 = ChunkCoords.fromBlock(location2.getBlockX()))) {
            return false;
        }
        int chunkZ1 = ChunkCoords.fromBlock(location1.getBlockZ());
        return chunkZ1 == (chunkZ2 = ChunkCoords.fromBlock(location2.getBlockZ()));
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isChunkLoaded(@Nullable @UnknownKeyFor @Initialized Location location) {
        World world;
        if (location == null) {
            return false;
        }
        try {
            world = location.getWorld();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (world == null) {
            return false;
        }
        return world.isChunkLoaded(ChunkCoords.fromBlock(location.getBlockX()), ChunkCoords.fromBlock(location.getBlockZ()));
    }

    public static @UnknownKeyFor @NonNull @Initialized ChunkCoords fromBlock(@UnknownKeyFor @NonNull @Initialized String worldName, @UnknownKeyFor @NonNull @Initialized int blockX, @UnknownKeyFor @NonNull @Initialized int blockZ) {
        return new ChunkCoords(worldName, ChunkCoords.fromBlock(blockX), ChunkCoords.fromBlock(blockZ));
    }

    public ChunkCoords(@UnknownKeyFor @NonNull @Initialized String worldName, @UnknownKeyFor @NonNull @Initialized int chunkX, @UnknownKeyFor @NonNull @Initialized int chunkZ) {
        Preconditions.checkNotNull((Object)worldName, (Object)"worldName is null");
        Preconditions.checkArgument((!worldName.isEmpty() ? 1 : 0) != 0, (Object)"worldName is empty");
        this.worldName = worldName;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    public ChunkCoords(@UnknownKeyFor @NonNull @Initialized Chunk chunk) {
        this(chunk.getWorld().getName(), chunk.getX(), chunk.getZ());
    }

    public ChunkCoords(@UnknownKeyFor @NonNull @Initialized ChunkCoords chunkCoords) {
        this(chunkCoords.getWorldName(), chunkCoords.getChunkX(), chunkCoords.getChunkZ());
    }

    public ChunkCoords(@UnknownKeyFor @NonNull @Initialized Location location) {
        this(ChunkCoords.getWorldName(location), ChunkCoords.fromBlock(location.getBlockX()), ChunkCoords.fromBlock(location.getBlockZ()));
    }

    private static @UnknownKeyFor @NonNull @Initialized String getWorldName(@UnknownKeyFor @NonNull @Initialized Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"location is null");
        World world = location.getWorld();
        Preconditions.checkNotNull((Object)world, (Object)"location's world is null");
        return Unsafe.assertNonNull(world).getName();
    }

    public ChunkCoords(@UnknownKeyFor @NonNull @Initialized Block block) {
        this(block.getWorld().getName(), ChunkCoords.fromBlock(block.getX()), ChunkCoords.fromBlock(block.getZ()));
    }

    public @UnknownKeyFor @NonNull @Initialized String getWorldName() {
        return this.worldName;
    }

    protected void setWorldName(@UnknownKeyFor @NonNull @Initialized String worldName) {
        Preconditions.checkNotNull((Object)worldName, (Object)"worldName is null");
        Preconditions.checkArgument((!worldName.isEmpty() ? 1 : 0) != 0, (Object)"worldName is empty");
        this.worldName = worldName;
    }

    public @UnknownKeyFor @NonNull @Initialized int getChunkX() {
        return this.chunkX;
    }

    protected void setChunkX(@UnknownKeyFor @NonNull @Initialized int chunkX) {
        this.chunkX = chunkX;
    }

    public @UnknownKeyFor @NonNull @Initialized int getChunkZ() {
        return this.chunkZ;
    }

    protected void setChunkZ(@UnknownKeyFor @NonNull @Initialized int chunkZ) {
        this.chunkZ = chunkZ;
    }

    public @Nullable @UnknownKeyFor @Initialized World getWorld() {
        return Bukkit.getWorld((String)this.worldName);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isChunkLoaded() {
        World world = this.getWorld();
        if (world != null) {
            return world.isChunkLoaded(this.chunkX, this.chunkZ);
        }
        return false;
    }

    public @Nullable @UnknownKeyFor @Initialized Chunk getChunk() {
        World world = this.getWorld();
        if (world != null && world.isChunkLoaded(this.chunkX, this.chunkZ)) {
            return world.getChunkAt(this.chunkX, this.chunkZ);
        }
        return null;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.worldName.hashCode();
        result = 31 * result + this.chunkX;
        result = 31 * result + this.chunkZ;
        return result;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChunkCoords)) {
            return false;
        }
        ChunkCoords other = (ChunkCoords)obj;
        return this.matches(other.worldName, other.chunkX, other.chunkZ);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean matches(@Nullable @UnknownKeyFor @Initialized String worldName, @UnknownKeyFor @NonNull @Initialized int chunkX, @UnknownKeyFor @NonNull @Initialized int chunkZ) {
        if (this.chunkX != chunkX) {
            return false;
        }
        if (this.chunkZ != chunkZ) {
            return false;
        }
        return this.worldName.equals(worldName);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean matches(@Nullable @UnknownKeyFor @Initialized Chunk chunk) {
        if (chunk == null) {
            return false;
        }
        return this.matches(chunk.getWorld().getName(), chunk.getX(), chunk.getZ());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" [worldName=");
        builder.append(this.worldName);
        builder.append(", chunkX=");
        builder.append(this.chunkX);
        builder.append(", chunkZ=");
        builder.append(this.chunkZ);
        builder.append("]");
        return builder.toString();
    }
}

