/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers.api.util;

import com.google.common.base.Preconditions;
import com.nisovin.shopkeepers.api.internal.ApiInternals;
import com.nisovin.shopkeepers.api.internal.util.Unsafe;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public interface UnmodifiableItemStack
extends ConfigurationSerializable {
    public static @Nullable @UnknownKeyFor @Initialized UnmodifiableItemStack of(@Nullable @UnknownKeyFor @Initialized ItemStack itemStack) {
        return ApiInternals.getInstance().createUnmodifiableItemStack(itemStack);
    }

    public static @UnknownKeyFor @NonNull @Initialized UnmodifiableItemStack ofNonNull(@UnknownKeyFor @NonNull @Initialized ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack, (Object)"itemStack is null");
        UnmodifiableItemStack unmodifiableItemStack = UnmodifiableItemStack.of(itemStack);
        return Unsafe.assertNonNull(unmodifiableItemStack);
    }

    public @UnknownKeyFor @NonNull @Initialized ItemStack copy();

    public @UnknownKeyFor @NonNull @Initialized UnmodifiableItemStack shallowCopy();

    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized ItemStack asItemStack();

    public @UnknownKeyFor @NonNull @Initialized Material getType();

    public @UnknownKeyFor @NonNull @Initialized int getAmount();

    public @UnknownKeyFor @NonNull @Initialized int getMaxStackSize();

    public @UnknownKeyFor @NonNull @Initialized boolean isSimilar(@Nullable @UnknownKeyFor @Initialized ItemStack var1);

    public @UnknownKeyFor @NonNull @Initialized boolean isSimilar(@Nullable @UnknownKeyFor @Initialized UnmodifiableItemStack var1);

    default public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized ItemStack itemStack) {
        return this.equals((Object)itemStack);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object var1);

    public @UnknownKeyFor @NonNull @Initialized boolean containsEnchantment(@UnknownKeyFor @NonNull @Initialized Enchantment var1);

    public @UnknownKeyFor @NonNull @Initialized int getEnchantmentLevel(@UnknownKeyFor @NonNull @Initialized Enchantment var1);

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Enchantment, @UnknownKeyFor @NonNull @Initialized Integer> getEnchantments();

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> serialize();

    public @Nullable @UnknownKeyFor @Initialized ItemMeta getItemMeta();

    public @UnknownKeyFor @NonNull @Initialized boolean hasItemMeta();
}

