/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.commands.PaginatedCommand;
import com.onarandombox.MultiverseCore.commands.PaginatedCoreCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class AnchorCommand
extends PaginatedCoreCommand<String> {
    public AnchorCommand(MultiverseCore plugin) {
        super(plugin);
        this.setName("Create, Delete and Manage Anchor Destinations.");
        this.setCommandUsage("/mv anchor " + (Object)((Object)ChatColor.GREEN) + "{name}" + (Object)((Object)ChatColor.GOLD) + " [-d]");
        this.setArgRange(0, 2);
        this.addKey("mv anchor");
        this.addKey("mv anchors");
        this.addKey("mvanchor");
        this.addKey("mvanchors");
        this.addCommandExample("/mv anchor " + (Object)((Object)ChatColor.GREEN) + "awesomething");
        this.addCommandExample("/mv anchor " + (Object)((Object)ChatColor.GREEN) + "otherthing");
        this.addCommandExample("/mv anchor " + (Object)((Object)ChatColor.GREEN) + "awesomething " + (Object)((Object)ChatColor.RED) + "-d");
        this.addCommandExample("/mv anchors ");
        this.setPermission("multiverse.core.anchor.list", "Allows a player to list all anchors.", PermissionDefault.OP);
        this.addAdditonalPermission(new Permission("multiverse.core.anchor.create", "Allows a player to create anchors.", PermissionDefault.OP));
        this.addAdditonalPermission(new Permission("multiverse.core.anchor.delete", "Allows a player to delete anchors.", PermissionDefault.OP));
        this.setItemsPerPage(8);
    }

    private List<String> getFancyAnchorList(Player p) {
        ArrayList<String> anchorList = new ArrayList<String>();
        ChatColor color = ChatColor.GREEN;
        for (String anchor : this.plugin.getAnchorManager().getAnchors(p)) {
            anchorList.add((Object)((Object)color) + anchor);
            color = color == ChatColor.GREEN ? ChatColor.GOLD : ChatColor.GREEN;
        }
        return anchorList;
    }

    private void showList(CommandSender sender, List<String> args) {
        if (!this.plugin.getMVPerms().hasPermission(sender, "multiverse.core.anchor.list", true)) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "You don't have the permission to list anchors!");
            return;
        }
        sender.sendMessage((Object)((Object)ChatColor.LIGHT_PURPLE) + "====[ Multiverse Anchor List ]====");
        Player p = null;
        if (sender instanceof Player) {
            p = (Player)sender;
        }
        PaginatedCommand.FilterObject filterObject = this.getPageAndFilter(args);
        List<String> availableAnchors = new ArrayList<String>(this.getFancyAnchorList(p));
        if (filterObject.getFilter().length() > 0) {
            if ((availableAnchors = this.getFilteredItems(availableAnchors, filterObject.getFilter())).size() == 0) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Sorry... " + (Object)((Object)ChatColor.WHITE) + "No anchors matched your filter: " + (Object)((Object)ChatColor.AQUA) + filterObject.getFilter());
                return;
            }
        } else if (availableAnchors.size() == 0) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Sorry... " + (Object)((Object)ChatColor.WHITE) + "No anchors were defined.");
            return;
        }
        if (!(sender instanceof Player)) {
            for (String c : availableAnchors) {
                sender.sendMessage(c);
            }
            return;
        }
        int totalPages = (int)Math.ceil((double)availableAnchors.size() / ((double)this.itemsPerPage + 0.0));
        if (filterObject.getPage() > totalPages) {
            filterObject.setPage(totalPages);
        } else if (filterObject.getPage() < 1) {
            filterObject.setPage(1);
        }
        sender.sendMessage((Object)((Object)ChatColor.AQUA) + " Page " + filterObject.getPage() + " of " + totalPages);
        this.showPage(filterObject.getPage(), sender, availableAnchors);
    }

    @Override
    public void runCommand(CommandSender sender, List<String> args) {
        if (args.size() == 0) {
            this.showList(sender, args);
            return;
        }
        if (args.size() == 1 && (this.getPageAndFilter(args).getPage() != 1 || args.get(0).equals("1"))) {
            this.showList(sender, args);
            return;
        }
        if (args.size() == 2 && args.get(1).equalsIgnoreCase("-d")) {
            if (!this.plugin.getMVPerms().hasPermission(sender, "multiverse.core.anchor.delete", true)) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "You don't have the permission to delete anchors!");
            } else if (this.plugin.getAnchorManager().deleteAnchor(args.get(0))) {
                sender.sendMessage("Anchor '" + args.get(0) + "' was successfully " + (Object)((Object)ChatColor.RED) + "deleted!");
            } else {
                sender.sendMessage("Anchor '" + args.get(0) + "' was " + (Object)((Object)ChatColor.RED) + " NOT " + (Object)((Object)ChatColor.WHITE) + "deleted!");
            }
            return;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("You must be a player to create Anchors.");
            return;
        }
        if (!this.plugin.getMVPerms().hasPermission(sender, "multiverse.core.anchor.create", true)) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "You don't have the permission to create anchors!");
        } else {
            Player player = (Player)sender;
            if (this.plugin.getAnchorManager().saveAnchorLocation(args.get(0), player.getLocation())) {
                sender.sendMessage("Anchor '" + args.get(0) + "' was successfully " + (Object)((Object)ChatColor.GREEN) + "created!");
            } else {
                sender.sendMessage("Anchor '" + args.get(0) + "' was " + (Object)((Object)ChatColor.RED) + " NOT " + (Object)((Object)ChatColor.WHITE) + "created!");
            }
        }
    }

    @Override
    protected List<String> getFilteredItems(List<String> availableItems, String filter) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (String s : availableItems) {
            if (!s.matches("(?i).*" + filter + ".*")) continue;
            filtered.add(s);
        }
        return filtered;
    }

    @Override
    protected String getItemText(String item) {
        return item;
    }
}

