/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.commands.MultiverseCommand;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;

public class GameruleCommand
extends MultiverseCommand {
    public GameruleCommand(MultiverseCore plugin) {
        super(plugin);
        this.setName("Set a Minecraft Game Rule for a World.");
        this.setCommandUsage("/mv gamerule " + (Object)((Object)ChatColor.GREEN) + "{RULE} {VALUE}" + (Object)((Object)ChatColor.GOLD) + " [WORLD]");
        this.setArgRange(2, 3);
        this.addKey("mv gamerule");
        this.addKey("mv rule");
        this.addKey("mvgamerule");
        this.addKey("mvrule");
        this.addCommandExample("/mv gamerule " + (Object)((Object)ChatColor.GREEN) + "doMobLoot false");
        this.addCommandExample("/mvrule " + (Object)((Object)ChatColor.GREEN) + "keepInventory true " + (Object)((Object)ChatColor.RED) + "world_nether");
        this.setPermission("multiverse.core.gamerule.set", "Allows a player to set a gamerule.", PermissionDefault.OP);
    }

    @Override
    public void runCommand(CommandSender sender, List<String> args) {
        World world;
        Player p = sender instanceof Player ? (Player)sender : null;
        if (args.size() == 2 && p == null) {
            sender.sendMessage("From the command line, WORLD is required.");
            sender.sendMessage(this.getCommandDesc());
            sender.sendMessage(this.getCommandUsage());
            sender.sendMessage("Nothing changed.");
            return;
        }
        GameRule<?> gameRule = GameRule.getByName(args.get(0));
        String value = args.get(1);
        if (args.size() == 2) {
            world = p.getWorld();
        } else {
            world = Bukkit.getWorld(args.get(2));
            if (world == null) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Failure!" + (Object)((Object)ChatColor.WHITE) + " World " + (Object)((Object)ChatColor.AQUA) + args.get(2) + (Object)((Object)ChatColor.WHITE) + " does not exist.");
                return;
            }
        }
        if (gameRule == null) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Failure! " + (Object)((Object)ChatColor.AQUA) + args.get(0) + (Object)((Object)ChatColor.WHITE) + " is not a valid gamerule.");
        } else {
            block17: {
                if (gameRule.getType() == Boolean.class) {
                    boolean booleanValue;
                    if (value.equalsIgnoreCase("true")) {
                        booleanValue = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        booleanValue = false;
                    } else {
                        sender.sendMessage(this.getErrorMessage(gameRule.getName(), value) + "it can only be set to true or false.");
                        return;
                    }
                    if (!world.setGameRule(gameRule, booleanValue)) {
                        sender.sendMessage(this.getErrorMessage(gameRule.getName(), value) + "something went wrong.");
                        return;
                    }
                } else {
                    if (gameRule.getType() == Integer.class) {
                        try {
                            if (!world.setGameRule(gameRule, Integer.parseInt(value))) {
                                throw new NumberFormatException();
                            }
                            break block17;
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(this.getErrorMessage(gameRule.getName(), value) + "it can only be set to a positive integer.");
                            return;
                        }
                    }
                    sender.sendMessage((Object)((Object)ChatColor.RED) + "Failure!" + (Object)((Object)ChatColor.WHITE) + " Gamerule " + (Object)((Object)ChatColor.AQUA) + gameRule.getName() + (Object)((Object)ChatColor.WHITE) + " isn't supported yet, please let us know about it.");
                    return;
                }
            }
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Success!" + (Object)((Object)ChatColor.WHITE) + " Gamerule " + (Object)((Object)ChatColor.AQUA) + gameRule.getName() + (Object)((Object)ChatColor.WHITE) + " was set to " + (Object)((Object)ChatColor.GREEN) + value + (Object)((Object)ChatColor.WHITE) + ".");
        }
    }

    private String getErrorMessage(String gameRule, String value) {
        return (Object)((Object)ChatColor.RED) + "Failure!" + (Object)((Object)ChatColor.WHITE) + " Gamerule " + (Object)((Object)ChatColor.AQUA) + gameRule + (Object)((Object)ChatColor.WHITE) + " could not be set to " + (Object)((Object)ChatColor.RED) + value + (Object)((Object)ChatColor.WHITE) + ", ";
    }
}

