/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.commands.MultiverseCommand;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;

public class GamerulesCommand
extends MultiverseCommand {
    public GamerulesCommand(MultiverseCore plugin) {
        super(plugin);
        this.setName("List the Minecraft Game Rules for a World.");
        this.setCommandUsage("/mv gamerules" + (Object)((Object)ChatColor.GOLD) + " [WORLD]");
        this.setArgRange(0, 1);
        this.addKey("mv gamerules");
        this.addKey("mv rules");
        this.addKey("mvgamerules");
        this.addKey("mvrules");
        this.addCommandExample("/mv gamerules");
        this.addCommandExample("/mvrules " + (Object)((Object)ChatColor.RED) + "world_nether");
        this.setPermission("multiverse.core.gamerule.list", "Allows a player to list gamerules.", PermissionDefault.OP);
    }

    @Override
    public void runCommand(CommandSender sender, List<String> args) {
        World world;
        Player p = sender instanceof Player ? (Player)sender : null;
        if (args.size() == 0 && p == null) {
            sender.sendMessage("From the command line, WORLD is required.");
            sender.sendMessage(this.getCommandDesc());
            sender.sendMessage(this.getCommandUsage());
            sender.sendMessage("Nothing changed.");
            return;
        }
        if (args.size() == 0) {
            world = p.getWorld();
        } else {
            world = Bukkit.getWorld(args.get(0));
            if (world == null) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Failure!" + (Object)((Object)ChatColor.WHITE) + " World " + (Object)((Object)ChatColor.AQUA) + args.get(0) + (Object)((Object)ChatColor.WHITE) + " does not exist.");
                return;
            }
        }
        StringBuilder gameRules = new StringBuilder();
        for (String gameRule : world.getGameRules()) {
            if (gameRules.length() != 0) {
                gameRules.append((Object)ChatColor.WHITE).append(", ");
            }
            gameRules.append((Object)ChatColor.AQUA).append(gameRule).append((Object)ChatColor.WHITE).append(": ");
            gameRules.append((Object)ChatColor.GREEN).append(world.getGameRuleValue(GameRule.getByName(gameRule)));
        }
        sender.sendMessage("=== Gamerules for " + (Object)((Object)ChatColor.AQUA) + world.getName() + (Object)((Object)ChatColor.WHITE) + " ===");
        sender.sendMessage(gameRules.toString());
    }
}

