/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.commands.PaginatedCommand;
import com.onarandombox.MultiverseCore.commands.PaginatedCoreCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;

public class ListCommand
extends PaginatedCoreCommand<String> {
    public ListCommand(MultiverseCore plugin) {
        super(plugin);
        this.setName("World Listing");
        this.setCommandUsage("/mv list [page]");
        this.setArgRange(0, 2);
        this.addKey("mvlist");
        this.addKey("mvl");
        this.addKey("mv list");
        this.setPermission("multiverse.core.list.worlds", "Displays a listing of all worlds that you can enter.", PermissionDefault.OP);
        this.setItemsPerPage(8);
    }

    private List<String> getFancyWorldList(Player p) {
        ArrayList<String> worldList = new ArrayList<String>();
        for (MultiverseWorld world : this.plugin.getMVWorldManager().getMVWorlds()) {
            if (p != null && !this.plugin.getMVPerms().canEnterWorld(p, world)) continue;
            ChatColor color = ChatColor.GOLD;
            World.Environment env = world.getEnvironment();
            if (env == World.Environment.NETHER) {
                color = ChatColor.RED;
            } else if (env == World.Environment.NORMAL) {
                color = ChatColor.GREEN;
            } else if (env == World.Environment.THE_END) {
                color = ChatColor.AQUA;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(world.getColoredWorldString()).append((Object)ChatColor.WHITE);
            builder.append(" - ").append((Object)color).append((Object)world.getEnvironment());
            if (world.isHidden()) {
                if (p != null && !this.plugin.getMVPerms().hasPermission(p, "multiverse.core.modify", true)) continue;
                worldList.add((Object)((Object)ChatColor.GRAY) + "[H]" + builder.toString());
                continue;
            }
            worldList.add(builder.toString());
        }
        for (String name : this.plugin.getMVWorldManager().getUnloadedWorlds()) {
            if (p != null && !this.plugin.getMVPerms().hasPermission(p, "multiverse.access." + name, true)) continue;
            worldList.add((Object)((Object)ChatColor.GRAY) + name + " - UNLOADED");
        }
        return worldList;
    }

    @Override
    protected List<String> getFilteredItems(List<String> availableItems, String filter) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (String s : availableItems) {
            if (!s.matches("(?i).*" + filter + ".*")) continue;
            filtered.add(s);
        }
        return filtered;
    }

    @Override
    protected String getItemText(String item) {
        return item;
    }

    @Override
    public void runCommand(CommandSender sender, List<String> args) {
        sender.sendMessage((Object)((Object)ChatColor.LIGHT_PURPLE) + "====[ Multiverse World List ]====");
        Player p = null;
        if (sender instanceof Player) {
            p = (Player)sender;
        }
        PaginatedCommand.FilterObject filterObject = this.getPageAndFilter(args);
        List<String> availableWorlds = new ArrayList<String>(this.getFancyWorldList(p));
        if (filterObject.getFilter().length() > 0 && (availableWorlds = this.getFilteredItems(availableWorlds, filterObject.getFilter())).size() == 0) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Sorry... " + (Object)((Object)ChatColor.WHITE) + "No worlds matched your filter: " + (Object)((Object)ChatColor.AQUA) + filterObject.getFilter());
            return;
        }
        if (!(sender instanceof Player)) {
            for (String c : availableWorlds) {
                sender.sendMessage(c);
            }
            return;
        }
        int totalPages = (int)Math.ceil((double)availableWorlds.size() / ((double)this.itemsPerPage + 0.0));
        if (filterObject.getPage() > totalPages) {
            filterObject.setPage(totalPages);
        }
        sender.sendMessage((Object)((Object)ChatColor.AQUA) + " Page " + filterObject.getPage() + " of " + totalPages);
        this.showPage(filterObject.getPage(), sender, availableWorlds);
    }
}

