/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.commands.ModifyCommand;
import com.onarandombox.MultiverseCore.commands.MultiverseCommand;
import com.onarandombox.MultiverseCore.enums.Action;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;

public class ModifyClearCommand
extends MultiverseCommand {
    private MVWorldManager worldManager;

    public ModifyClearCommand(MultiverseCore plugin) {
        super(plugin);
        this.setName("Modify a World (Clear a property)");
        this.setCommandUsage("/mv modify" + (Object)((Object)ChatColor.GREEN) + " clear {PROPERTY}" + (Object)((Object)ChatColor.GOLD) + " [WORLD]");
        this.setArgRange(1, 2);
        this.addKey("mvm clear");
        this.addKey("mvmclear");
        this.addKey("mv modify clear");
        this.addKey("mvmodify clear");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "clear " + (Object)((Object)ChatColor.RED) + "animals");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "clear " + (Object)((Object)ChatColor.RED) + "monsters");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "clear " + (Object)((Object)ChatColor.RED) + "worldblacklist");
        this.setPermission("multiverse.core.modify.clear", "Removes all values from a property. This will work on properties that contain lists.", PermissionDefault.OP);
        this.worldManager = this.plugin.getMVWorldManager();
    }

    @Override
    public void runCommand(CommandSender sender, List<String> args) {
        Player p = null;
        if (sender instanceof Player) {
            p = (Player)sender;
        }
        if (args.size() == 1 && p == null) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "From the console, WORLD is required.");
            sender.sendMessage(this.getCommandDesc());
            sender.sendMessage(this.getCommandUsage());
            sender.sendMessage("Nothing changed.");
            return;
        }
        String property = args.get(0);
        MultiverseWorld world = args.size() == 1 ? this.worldManager.getMVWorld(p.getWorld().getName()) : this.worldManager.getMVWorld(args.get(1));
        if (world == null) {
            sender.sendMessage("That world does not exist!");
            return;
        }
        if (!ModifyCommand.validateAction(Action.Clear, property)) {
            sender.sendMessage("Sorry, you can't use CLEAR with " + property);
            sender.sendMessage("Please visit our Github Wiki for more information: https://goo.gl/q1h01S");
            return;
        }
        if (world.clearList(property)) {
            sender.sendMessage(property + " was cleared. It contains 0 values now.");
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Success! " + (Object)((Object)ChatColor.AQUA) + property + (Object)((Object)ChatColor.WHITE) + " was " + (Object)((Object)ChatColor.GREEN) + "CLEARED" + (Object)((Object)ChatColor.WHITE) + ". It contains " + (Object)((Object)ChatColor.LIGHT_PURPLE) + "0" + (Object)((Object)ChatColor.WHITE) + " values now.");
            if (!this.plugin.saveWorldConfig()) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "There was an issue saving worlds.yml!  Your changes will only be temporary!");
            }
        } else {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Error: " + (Object)((Object)ChatColor.GOLD) + property + (Object)((Object)ChatColor.WHITE) + " was " + (Object)((Object)ChatColor.GOLD) + "NOT" + (Object)((Object)ChatColor.WHITE) + " cleared.");
        }
    }
}

