/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.commands.MultiverseCommand;
import com.onarandombox.MultiverseCore.commands.SetSpawnCommand;
import com.onarandombox.MultiverseCore.enums.EnglishChatColor;
import com.onarandombox.MultiverseCore.exceptions.PropertyDoesNotExistException;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;

public class ModifySetCommand
extends MultiverseCommand {
    private MVWorldManager worldManager;

    public ModifySetCommand(MultiverseCore plugin) {
        super(plugin);
        this.worldManager = this.plugin.getMVWorldManager();
        this.setName("Modify a World (Set a value)");
        this.setCommandUsage("/mv modify" + (Object)((Object)ChatColor.GREEN) + " set {PROPERTY} {VALUE}" + (Object)((Object)ChatColor.GOLD) + " [WORLD]");
        this.setArgRange(1, 3);
        this.addKey("mvm set");
        this.addKey("mvmset");
        this.addKey("mv modify set");
        this.addKey("mvmodify set");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "mode " + (Object)((Object)ChatColor.RED) + "creative");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "animals " + (Object)((Object)ChatColor.RED) + "false");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "monsters " + (Object)((Object)ChatColor.RED) + "false");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "alias " + (Object)((Object)ChatColor.RED) + "MyWorld");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "color " + (Object)((Object)ChatColor.RED) + "green");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "curr " + (Object)((Object)ChatColor.RED) + "3");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "price " + (Object)((Object)ChatColor.RED) + "5");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "scale " + (Object)((Object)ChatColor.RED) + "1.2");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "memory " + (Object)((Object)ChatColor.RED) + "true");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "diff " + (Object)((Object)ChatColor.RED) + "hard");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "hunger " + (Object)((Object)ChatColor.RED) + "false");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "hidden " + (Object)((Object)ChatColor.RED) + "true");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "pvp " + (Object)((Object)ChatColor.RED) + "false");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "heal " + (Object)((Object)ChatColor.RED) + "true");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "adjustspawn " + (Object)((Object)ChatColor.RED) + "false");
        this.addCommandExample("/mvm " + (Object)((Object)ChatColor.GOLD) + "set " + (Object)((Object)ChatColor.GREEN) + "spawn");
        this.setPermission("multiverse.core.modify.set", "Modify various aspects of worlds. See the help wiki for how to use this command properly. If you do not include a world, the current world will be used.", PermissionDefault.OP);
    }

    @Override
    public void runCommand(CommandSender sender, List<String> args) {
        if (args.size() == 1) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("You must be a player to set the" + (Object)((Object)ChatColor.GREEN) + " spawn");
                return;
            }
            if (args.get(0).equalsIgnoreCase("spawn")) {
                SetSpawnCommand c = new SetSpawnCommand(this.plugin);
                c.setWorldSpawn(sender);
            } else {
                sender.sendMessage("Spawn is the only param with no" + (Object)((Object)ChatColor.GREEN) + " VALUE");
                sender.sendMessage("Type " + (Object)((Object)ChatColor.GREEN) + "/mv modify ?" + (Object)((Object)ChatColor.WHITE) + " For help.");
            }
            return;
        }
        Player p = null;
        if (sender instanceof Player) {
            p = (Player)sender;
        }
        if (args.size() == 2 && p == null) {
            sender.sendMessage("From the command line, WORLD is required.");
            sender.sendMessage(this.getCommandDesc());
            sender.sendMessage(this.getCommandUsage());
            sender.sendMessage("Nothing changed.");
            return;
        }
        String value = args.get(1);
        String property = args.get(0);
        MultiverseWorld world = args.size() == 2 ? this.worldManager.getMVWorld(p.getWorld().getName()) : this.worldManager.getMVWorld(args.get(2));
        if (world == null) {
            sender.sendMessage("That world does not exist!");
            return;
        }
        if ((property.equalsIgnoreCase("aliascolor") || property.equalsIgnoreCase("color")) && !EnglishChatColor.isValidAliasColor(value)) {
            sender.sendMessage(value + " is not a valid color. Please pick one of the following:");
            sender.sendMessage(EnglishChatColor.getAllColors());
            return;
        }
        try {
            if (world.setPropertyValue(property, value)) {
                sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Success!" + (Object)((Object)ChatColor.WHITE) + " Property " + (Object)((Object)ChatColor.AQUA) + property + (Object)((Object)ChatColor.WHITE) + " was set to " + (Object)((Object)ChatColor.GREEN) + value);
                if (!this.plugin.saveWorldConfig()) {
                    sender.sendMessage((Object)((Object)ChatColor.RED) + "There was an issue saving worlds.yml!  Your changes will only be temporary!");
                }
            } else {
                sender.sendMessage((Object)((Object)ChatColor.RED) + world.getPropertyHelp(property));
            }
        }
        catch (PropertyDoesNotExistException e) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Sorry, You can't set: '" + (Object)((Object)ChatColor.GRAY) + property + (Object)((Object)ChatColor.RED) + "'");
            sender.sendMessage("Valid world-properties: " + world.getAllPropertyNames());
        }
    }
}

