/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.commands.MultiverseCommand;
import com.onarandombox.MultiverseCore.event.MVVersionEvent;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import com.onarandombox.MultiverseCore.utils.webpaste.PasteFailedException;
import com.onarandombox.MultiverseCore.utils.webpaste.PasteService;
import com.onarandombox.MultiverseCore.utils.webpaste.PasteServiceFactory;
import com.onarandombox.MultiverseCore.utils.webpaste.PasteServiceType;
import com.onarandombox.MultiverseCore.utils.webpaste.URLShortener;
import com.onarandombox.MultiverseCore.utils.webpaste.URLShortenerFactory;
import com.onarandombox.MultiverseCore.utils.webpaste.URLShortenerType;
import com.onarandombox.commandhandler.CommandHandler;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.scheduler.BukkitRunnable;

public class VersionCommand
extends MultiverseCommand {
    private static final URLShortener SHORTENER = URLShortenerFactory.getService(URLShortenerType.BITLY);

    public VersionCommand(MultiverseCore plugin) {
        super(plugin);
        this.setName("Multiverse Version");
        this.setCommandUsage("/mv version " + (Object)((Object)ChatColor.GOLD) + "[-b|-h|-p] [--include-plugin-list]");
        this.setArgRange(0, 2);
        this.addKey("mv version");
        this.addKey("mvver");
        this.addKey("mvv");
        this.addKey("mvversion");
        this.setPermission("multiverse.core.version", "Dumps version info to the console, optionally to pastebin.com with -b, to hastebin.com using -h, or to paste.gg with -p.", PermissionDefault.TRUE);
    }

    private String getLegacyString() {
        return "[Multiverse-Core] Multiverse-Core Version: " + this.plugin.getDescription().getVersion() + '\n' + "[Multiverse-Core] Bukkit Version: " + this.plugin.getServer().getVersion() + '\n' + "[Multiverse-Core] Loaded Worlds: " + this.plugin.getMVWorldManager().getMVWorlds() + '\n' + "[Multiverse-Core] Multiverse Plugins Loaded: " + this.plugin.getPluginCount() + '\n' + "[Multiverse-Core] Economy being used: " + this.plugin.getEconomist().getEconomyName() + '\n' + "[Multiverse-Core] Permissions Plugin: " + this.plugin.getMVPerms().getType() + '\n' + "[Multiverse-Core] Dumping Config Values: (version " + this.plugin.getMVConfig().getVersion() + ")" + '\n' + "[Multiverse-Core]   enforceaccess: " + this.plugin.getMVConfig().getEnforceAccess() + '\n' + "[Multiverse-Core]   prefixchat: " + this.plugin.getMVConfig().getPrefixChat() + '\n' + "[Multiverse-Core]   prefixchatformat: " + this.plugin.getMVConfig().getPrefixChatFormat() + '\n' + "[Multiverse-Core]   useasyncchat: " + this.plugin.getMVConfig().getUseAsyncChat() + '\n' + "[Multiverse-Core]   teleportintercept: " + this.plugin.getMVConfig().getTeleportIntercept() + '\n' + "[Multiverse-Core]   firstspawnoverride: " + this.plugin.getMVConfig().getFirstSpawnOverride() + '\n' + "[Multiverse-Core]   displaypermerrors: " + this.plugin.getMVConfig().getDisplayPermErrors() + '\n' + "[Multiverse-Core]   globaldebug: " + this.plugin.getMVConfig().getGlobalDebug() + '\n' + "[Multiverse-Core]   silentstart: " + this.plugin.getMVConfig().getSilentStart() + '\n' + "[Multiverse-Core]   messagecooldown: " + this.plugin.getMessaging().getCooldown() + '\n' + "[Multiverse-Core]   version: " + this.plugin.getMVConfig().getVersion() + '\n' + "[Multiverse-Core]   firstspawnworld: " + this.plugin.getMVConfig().getFirstSpawnWorld() + '\n' + "[Multiverse-Core]   teleportcooldown: " + this.plugin.getMVConfig().getTeleportCooldown() + '\n' + "[Multiverse-Core]   defaultportalsearch: " + this.plugin.getMVConfig().isUsingDefaultPortalSearch() + '\n' + "[Multiverse-Core]   portalsearchradius: " + this.plugin.getMVConfig().getPortalSearchRadius() + '\n' + "[Multiverse-Core]   autopurge: " + this.plugin.getMVConfig().isAutoPurgeEnabled() + '\n' + "[Multiverse-Core] Special Code: FRN002" + '\n';
    }

    private String getMarkdownString() {
        return "# Multiverse-Core\n## Overview\n| Name | Value |\n| --- | --- |\n| Multiverse-Core Version | `" + this.plugin.getDescription().getVersion() + "` |" + '\n' + "| Bukkit Version | `" + this.plugin.getServer().getVersion() + "` |" + '\n' + "| Loaded Worlds | `" + this.plugin.getMVWorldManager().getMVWorlds() + "` |" + '\n' + "| Multiverse Plugins Loaded | `" + this.plugin.getPluginCount() + "` |" + '\n' + "| Economy being used | `" + this.plugin.getEconomist().getEconomyName() + "` |" + '\n' + "| Permissions Plugin | `" + this.plugin.getMVPerms().getType() + "` |" + '\n' + "## Parsed Config" + '\n' + "These are what Multiverse thought the in-memory values of the config were.\n\n| Config Key  | Value |" + '\n' + "| --- | --- |" + '\n' + "| version | `" + this.plugin.getMVConfig().getVersion() + "` |" + '\n' + "| messagecooldown | `" + this.plugin.getMessaging().getCooldown() + "` |" + '\n' + "| teleportcooldown | `" + this.plugin.getMVConfig().getTeleportCooldown() + "` |" + '\n' + "| worldnameprefix | `" + this.plugin.getMVConfig().getPrefixChat() + "` |" + '\n' + "| worldnameprefixFormat | `" + this.plugin.getMVConfig().getPrefixChatFormat() + "` |" + '\n' + "| enforceaccess | `" + this.plugin.getMVConfig().getEnforceAccess() + "` |" + '\n' + "| displaypermerrors | `" + this.plugin.getMVConfig().getDisplayPermErrors() + "` |" + '\n' + "| teleportintercept | `" + this.plugin.getMVConfig().getTeleportIntercept() + "` |" + '\n' + "| firstspawnoverride | `" + this.plugin.getMVConfig().getFirstSpawnOverride() + "` |" + '\n' + "| firstspawnworld | `" + this.plugin.getMVConfig().getFirstSpawnWorld() + "` |" + '\n' + "| debug | `" + this.plugin.getMVConfig().getGlobalDebug() + "` |" + '\n';
    }

    private void addVersionInfoToEvent(MVVersionEvent event) {
        event.appendVersionInfo(this.getLegacyString());
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        event.putDetailedVersionInfo("multiverse-core/config.yml", configFile);
        File worldsFile = new File(this.plugin.getDataFolder(), "worlds.yml");
        event.putDetailedVersionInfo("multiverse-core/worlds.yml", worldsFile);
    }

    @Override
    public void runCommand(final CommandSender sender, final List<String> args) {
        String[] lines;
        if (sender instanceof Player) {
            sender.sendMessage("Version info dumped to console. Please check your server logs.");
        }
        MVVersionEvent versionEvent = new MVVersionEvent();
        this.addVersionInfoToEvent(versionEvent);
        this.plugin.getServer().getPluginManager().callEvent(versionEvent);
        if (CommandHandler.hasFlag("--include-plugin-list", args)) {
            versionEvent.appendVersionInfo("\nPlugins: " + this.getPluginList());
            versionEvent.putDetailedVersionInfo("plugins.txt", "Plugins: " + this.getPluginList());
        }
        final String versionInfo = versionEvent.getVersionInfo();
        versionEvent.putDetailedVersionInfo("version.txt", versionInfo);
        final Map<String, String> files = versionEvent.getDetailedVersionInfo();
        for (String line : lines = versionInfo.split("\\r?\\n")) {
            if (line.isEmpty()) continue;
            this.plugin.getServer().getLogger().info(line);
        }
        BukkitRunnable logPoster = new BukkitRunnable(){

            @Override
            public void run() {
                if (args.size() > 0) {
                    String pasteUrl;
                    if (CommandHandler.hasFlag("-b", args)) {
                        pasteUrl = VersionCommand.postToService(PasteServiceType.PASTEBIN, true, versionInfo, files);
                    } else if (CommandHandler.hasFlag("-g", args)) {
                        pasteUrl = VersionCommand.postToService(PasteServiceType.GITHUB, true, versionInfo, files);
                    } else if (CommandHandler.hasFlag("-h", args)) {
                        pasteUrl = VersionCommand.postToService(PasteServiceType.HASTEBIN, true, versionInfo, files);
                    } else if (CommandHandler.hasFlag("-p", args)) {
                        pasteUrl = VersionCommand.postToService(PasteServiceType.PASTEGG, true, versionInfo, files);
                    } else {
                        return;
                    }
                    if (!(sender instanceof ConsoleCommandSender)) {
                        sender.sendMessage("Version info dumped here: " + (Object)((Object)ChatColor.GREEN) + pasteUrl);
                    }
                    CoreLogging.info("Version info dumped here: %s", pasteUrl);
                }
            }
        };
        logPoster.runTaskAsynchronously(this.plugin);
    }

    private static String postToService(PasteServiceType type, boolean isPrivate, String pasteData, Map<String, String> pasteFiles) {
        PasteService ps = PasteServiceFactory.getService(type, isPrivate);
        try {
            String result = ps.supportsMultiFile() ? ps.postData(pasteFiles) : ps.postData(pasteData);
            if (SHORTENER != null) {
                return SHORTENER.shorten(result);
            }
            return result;
        }
        catch (PasteFailedException e) {
            e.printStackTrace();
            return "Error posting to service.";
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return "That service isn't supported yet.";
        }
    }

    private String getPluginList() {
        return StringUtils.join((Object[])this.plugin.getServer().getPluginManager().getPlugins(), ", ");
    }
}

