/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.destination;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.Core;
import com.onarandombox.MultiverseCore.api.MVDestination;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class WorldDestination
implements MVDestination {
    private boolean isValid;
    private MultiverseWorld world;
    private float yaw = -1.0f;
    private String direction = "";

    @Override
    public String getIdentifier() {
        return "w";
    }

    @Override
    public boolean isThisType(JavaPlugin plugin, String destination) {
        String[] items = destination.split(":");
        if (items.length > 3) {
            return false;
        }
        if (items.length == 1 && ((MultiverseCore)plugin).getMVWorldManager().isMVWorld(items[0])) {
            return true;
        }
        if (items.length == 2 && ((MultiverseCore)plugin).getMVWorldManager().isMVWorld(items[0])) {
            return true;
        }
        return items[0].equalsIgnoreCase("w") && ((MultiverseCore)plugin).getMVWorldManager().isMVWorld(items[1]);
    }

    @Override
    public Location getLocation(Entity e) {
        Location spawnLoc = WorldDestination.getAcurateSpawnLocation(e, this.world);
        if (this.yaw >= 0.0f) {
            spawnLoc.setYaw(this.yaw);
        }
        return spawnLoc;
    }

    private static Location getAcurateSpawnLocation(Entity e, MultiverseWorld world) {
        if (world != null) {
            return world.getSpawnLocation();
        }
        return e.getWorld().getSpawnLocation().add(0.5, 0.0, 0.5);
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setDestination(JavaPlugin plugin, String destination) {
        Core core = (Core)((Object)plugin);
        String[] items = destination.split(":");
        if (items.length > 3) {
            this.isValid = false;
            return;
        }
        if (items.length == 1 && ((MultiverseCore)plugin).getMVWorldManager().isMVWorld(items[0])) {
            this.isValid = true;
            this.world = core.getMVWorldManager().getMVWorld(items[0]);
            return;
        }
        if (items.length == 2 && ((MultiverseCore)plugin).getMVWorldManager().isMVWorld(items[0])) {
            this.world = core.getMVWorldManager().getMVWorld(items[0]);
            this.yaw = core.getLocationManipulation().getYaw(items[1]);
            return;
        }
        if (items[0].equalsIgnoreCase("w") && ((MultiverseCore)plugin).getMVWorldManager().isMVWorld(items[1])) {
            this.world = ((MultiverseCore)plugin).getMVWorldManager().getMVWorld(items[1]);
            this.isValid = true;
            if (items.length == 3) {
                this.yaw = core.getLocationManipulation().getYaw(items[2]);
            }
        }
    }

    @Override
    public String getType() {
        return "World";
    }

    @Override
    public String getName() {
        return this.world.getColoredWorldString();
    }

    @Override
    public String toString() {
        if (this.direction.length() > 0 && this.yaw >= 0.0f) {
            return this.world.getCBWorld().getName() + ":" + this.direction;
        }
        return this.world.getCBWorld().getName();
    }

    @Override
    public String getRequiredPermission() {
        return "multiverse.access." + this.world.getName();
    }

    @Override
    public Vector getVelocity() {
        return new Vector(0, 0, 0);
    }

    @Override
    public boolean useSafeTeleporter() {
        return true;
    }
}

