/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.utils.MVEconomist;
import com.onarandombox.MultiverseCore.utils.MVPermissions;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;

public class PermissionTools {
    private MultiverseCore plugin;

    public PermissionTools(MultiverseCore plugin) {
        this.plugin = plugin;
    }

    public void addToParentPerms(String permString) {
        Permission actualPermission;
        String permStringChopped = permString.replace(".*", "");
        String[] seperated = permStringChopped.split("\\.");
        String parentPermString = PermissionTools.getParentPerm(seperated);
        if (parentPermString == null) {
            this.addToRootPermission("*", permStringChopped);
            this.addToRootPermission("*.*", permStringChopped);
            return;
        }
        Permission parentPermission = this.plugin.getServer().getPluginManager().getPermission(parentPermString);
        if (parentPermission == null) {
            parentPermission = new Permission(parentPermString);
            this.plugin.getServer().getPluginManager().addPermission(parentPermission);
            this.addToParentPerms(parentPermString);
        }
        if ((actualPermission = this.plugin.getServer().getPluginManager().getPermission(permString)) == null) {
            actualPermission = new Permission(permString);
            this.plugin.getServer().getPluginManager().addPermission(actualPermission);
        }
        if (!parentPermission.getChildren().containsKey(permString)) {
            parentPermission.getChildren().put(actualPermission.getName(), true);
            this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(parentPermission);
        }
    }

    private void addToRootPermission(String rootPerm, String permStringChopped) {
        Permission rootPermission = this.plugin.getServer().getPluginManager().getPermission(rootPerm);
        if (rootPermission == null) {
            rootPermission = new Permission(rootPerm);
            this.plugin.getServer().getPluginManager().addPermission(rootPermission);
        }
        rootPermission.getChildren().put(permStringChopped + ".*", true);
        this.plugin.getServer().getPluginManager().recalculatePermissionDefaults(rootPermission);
    }

    private static String getParentPerm(String[] separatedPermissionString) {
        if (separatedPermissionString.length == 1) {
            return null;
        }
        String returnString = "";
        for (int i = 0; i < separatedPermissionString.length - 1; ++i) {
            returnString = returnString + separatedPermissionString[i] + ".";
        }
        return returnString + "*";
    }

    public boolean playerHasMoneyToEnter(MultiverseWorld fromWorld, MultiverseWorld toWorld, CommandSender teleporter, Player teleportee, boolean pay) {
        Player teleporterPlayer;
        if (this.plugin.getMVConfig().getTeleportIntercept()) {
            if (teleporter instanceof ConsoleCommandSender) {
                return true;
            }
            if (teleporter == null) {
                teleporter = teleportee;
            }
            if (!(teleporter instanceof Player)) {
                return false;
            }
            teleporterPlayer = (Player)teleporter;
        } else {
            teleporterPlayer = teleporter instanceof Player ? (Player)teleporter : null;
            if (teleporterPlayer == null) {
                return true;
            }
        }
        if (toWorld == null) {
            return true;
        }
        if (!toWorld.equals(fromWorld)) {
            double price = toWorld.getPrice();
            if (price == 0.0) {
                return true;
            }
            if (this.plugin.getMVPerms().hasPermission(teleporter, toWorld.getExemptPermission().getName(), true)) {
                return true;
            }
            MVEconomist economist = this.plugin.getEconomist();
            Material currency = toWorld.getCurrency();
            String formattedAmount = economist.formatPrice(price, currency);
            if (economist.isPlayerWealthyEnough(teleporterPlayer, price, currency)) {
                if (pay) {
                    if (price < 0.0) {
                        economist.deposit(teleporterPlayer, -price, currency);
                    } else {
                        economist.withdraw(teleporterPlayer, price, currency);
                    }
                    this.sendTeleportPaymentMessage(economist, teleporterPlayer, teleportee, toWorld.getColoredWorldString(), price, currency);
                }
            } else {
                if (teleportee.equals(teleporter)) {
                    teleporterPlayer.sendMessage(economist.getNSFMessage(currency, "You need " + formattedAmount + " to enter " + toWorld.getColoredWorldString()));
                } else {
                    teleporterPlayer.sendMessage(economist.getNSFMessage(currency, "You need " + formattedAmount + " to send " + teleportee.getName() + " to " + toWorld.getColoredWorldString()));
                }
                return false;
            }
        }
        return true;
    }

    private void sendTeleportPaymentMessage(MVEconomist economist, Player teleporterPlayer, Player teleportee, String toWorld, double price, Material currency) {
        price = Math.abs(price);
        if (teleporterPlayer.equals(teleportee)) {
            teleporterPlayer.sendMessage("You were " + (price > 0.0 ? "charged " : "given ") + economist.formatPrice(price, currency) + " for teleporting to " + toWorld);
        } else {
            teleporterPlayer.sendMessage("You were " + (price > 0.0 ? "charged " : "given ") + economist.formatPrice(price, currency) + " for teleporting " + teleportee.getName() + " to " + toWorld);
        }
    }

    public boolean playerCanGoFromTo(MultiverseWorld fromWorld, MultiverseWorld toWorld, CommandSender teleporter, Player teleportee) {
        Player teleporterPlayer;
        this.plugin.log(Level.FINEST, "Checking '" + teleporter + "' can send '" + teleportee + "' somewhere");
        if (this.plugin.getMVConfig().getTeleportIntercept()) {
            if (teleporter instanceof ConsoleCommandSender) {
                return true;
            }
            if (teleporter == null) {
                teleporter = teleportee;
            }
            if (!(teleporter instanceof Player)) {
                return false;
            }
            teleporterPlayer = (Player)teleporter;
        } else {
            teleporterPlayer = teleporter instanceof Player ? (Player)teleporter : null;
            if (teleporterPlayer == null) {
                return true;
            }
        }
        if (toWorld != null) {
            if (!this.plugin.getMVPerms().canEnterWorld(teleporterPlayer, toWorld)) {
                if (teleportee.equals(teleporter)) {
                    teleporter.sendMessage("You don't have access to go here...");
                } else {
                    teleporter.sendMessage("You can't send " + teleportee.getName() + " here...");
                }
                return false;
            }
        } else {
            return true;
        }
        if (fromWorld != null && fromWorld.getWorldBlacklist().contains(toWorld.getName())) {
            if (teleportee.equals(teleporter)) {
                teleporter.sendMessage("You don't have access to go to " + toWorld.getColoredWorldString() + " from " + fromWorld.getColoredWorldString());
            } else {
                teleporter.sendMessage("You don't have access to send " + teleportee.getName() + " from " + fromWorld.getColoredWorldString() + " to " + toWorld.getColoredWorldString());
            }
            return false;
        }
        return true;
    }

    public boolean playerCanBypassPlayerLimit(MultiverseWorld toWorld, CommandSender teleporter, Player teleportee) {
        if (teleporter == null) {
            teleporter = teleportee;
        }
        if (!(teleporter instanceof Player)) {
            return true;
        }
        MVPermissions perms = this.plugin.getMVPerms();
        if (perms.hasPermission(teleportee, "mv.bypass.playerlimit." + toWorld.getName(), false)) {
            return true;
        }
        teleporter.sendMessage("The world " + toWorld.getColoredWorldString() + " is full");
        return false;
    }

    public boolean playerCanIgnoreGameModeRestriction(MultiverseWorld toWorld, Player teleportee) {
        if (toWorld != null) {
            return this.plugin.getMVPerms().canIgnoreGameModeRestriction(teleportee, toWorld);
        }
        return true;
    }
}

