/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.api.BlockSafety;
import com.onarandombox.MultiverseCore.api.Core;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;

public class SimpleBlockSafety
implements BlockSafety {
    private final Core plugin;
    private static final Set<BlockFace> AROUND_BLOCK = EnumSet.noneOf(BlockFace.class);

    public SimpleBlockSafety(Core plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isBlockAboveAir(Location l) {
        Location downOne = l.clone();
        downOne.setY(downOne.getY() - 1.0);
        return downOne.getBlock().getType() == Material.AIR;
    }

    @Override
    public boolean playerCanSpawnHereSafely(World world, double x, double y, double z) {
        Location l = new Location(world, x, y, z);
        return this.playerCanSpawnHereSafely(l);
    }

    @Override
    public boolean playerCanSpawnHereSafely(Location l) {
        if (l == null) {
            return false;
        }
        World world = l.getWorld();
        Location actual = l.clone();
        Location upOne = l.clone();
        Location downOne = l.clone();
        upOne.setY(upOne.getY() + 1.0);
        downOne.setY(downOne.getY() - 1.0);
        if (SimpleBlockSafety.isSolidBlock(world.getBlockAt(actual).getType()) || SimpleBlockSafety.isSolidBlock(upOne.getBlock().getType())) {
            CoreLogging.finer("Error Here (Actual)? (%s)[%s]", actual.getBlock().getType(), SimpleBlockSafety.isSolidBlock(actual.getBlock().getType()));
            CoreLogging.finer("Error Here (upOne)? (%s)[%s]", upOne.getBlock().getType(), SimpleBlockSafety.isSolidBlock(upOne.getBlock().getType()));
            return false;
        }
        if (downOne.getBlock().getType() == Material.LAVA) {
            CoreLogging.finer("Error Here (downOne)? (%s)[%s]", downOne.getBlock().getType(), SimpleBlockSafety.isSolidBlock(downOne.getBlock().getType()));
            return false;
        }
        if (downOne.getBlock().getType() == Material.FIRE) {
            CoreLogging.finer("There's fire below! (%s)[%s]", actual.getBlock().getType(), SimpleBlockSafety.isSolidBlock(actual.getBlock().getType()));
            return false;
        }
        if (this.isBlockAboveAir(actual)) {
            CoreLogging.finer("Is block above air [%s]", this.isBlockAboveAir(actual));
            CoreLogging.finer("Has 2 blocks of water below [%s]", this.hasTwoBlocksofWaterBelow(actual));
            return this.hasTwoBlocksofWaterBelow(actual);
        }
        return true;
    }

    @Override
    public Location getSafeBedSpawn(Location l) {
        if (l == null) {
            return null;
        }
        Location trySpawn = this.getSafeSpawnAroundABlock(l);
        if (trySpawn != null) {
            return trySpawn;
        }
        Location otherBlock = this.findOtherBedPiece(l);
        if (otherBlock == null) {
            return null;
        }
        return this.getSafeSpawnAroundABlock(otherBlock);
    }

    private Location getSafeSpawnAroundABlock(Location l) {
        for (BlockFace face : AROUND_BLOCK) {
            if (!this.playerCanSpawnHereSafely(l.getBlock().getRelative(face).getLocation())) continue;
            return l.getBlock().getRelative(face).getLocation().add(0.5, 0.0, 0.5);
        }
        return null;
    }

    private Location findOtherBedPiece(Location checkLoc) {
        BlockData data = checkLoc.getBlock().getBlockData();
        if (!(data instanceof Bed)) {
            return null;
        }
        Bed b = (Bed)data;
        if (b.getPart() == Bed.Part.HEAD) {
            return checkLoc.getBlock().getRelative(b.getFacing().getOppositeFace()).getLocation();
        }
        return checkLoc.getBlock().getRelative(b.getFacing()).getLocation();
    }

    @Override
    public Location getTopBlock(Location l) {
        Location check = l.clone();
        check.setY(127.0);
        while (check.getY() > 0.0) {
            if (this.playerCanSpawnHereSafely(check)) {
                return check;
            }
            check.setY(check.getY() - 1.0);
        }
        return null;
    }

    @Override
    public Location getBottomBlock(Location l) {
        Location check = l.clone();
        check.setY(0.0);
        while (check.getY() < 127.0) {
            if (this.playerCanSpawnHereSafely(check)) {
                return check;
            }
            check.setY(check.getY() + 1.0);
        }
        return null;
    }

    public static boolean isSolidBlock(Material type) {
        return type.isSolid();
    }

    @Override
    public boolean isEntitiyOnTrack(Location l) {
        Material currentBlock = l.getBlock().getType();
        return currentBlock == Material.POWERED_RAIL || currentBlock == Material.DETECTOR_RAIL || currentBlock == Material.RAIL || currentBlock == Material.ACTIVATOR_RAIL;
    }

    private boolean hasTwoBlocksofWaterBelow(Location l) {
        if (l.getBlockY() < 0) {
            return false;
        }
        Location oneBelow = l.clone();
        oneBelow.subtract(0.0, 1.0, 0.0);
        if (oneBelow.getBlock().getType() == Material.WATER) {
            Location twoBelow = oneBelow.clone();
            twoBelow.subtract(0.0, 1.0, 0.0);
            return oneBelow.getBlock().getType() == Material.WATER;
        }
        if (oneBelow.getBlock().getType() != Material.AIR) {
            return false;
        }
        return this.hasTwoBlocksofWaterBelow(oneBelow);
    }

    @Override
    public boolean canSpawnCartSafely(Minecart cart) {
        if (this.isBlockAboveAir(cart.getLocation())) {
            return true;
        }
        return this.isEntitiyOnTrack(this.plugin.getLocationManipulation().getNextBlock(cart));
    }

    @Override
    public boolean canSpawnVehicleSafely(Vehicle vehicle) {
        return this.isBlockAboveAir(vehicle.getLocation());
    }

    static {
        AROUND_BLOCK.add(BlockFace.NORTH);
        AROUND_BLOCK.add(BlockFace.NORTH_EAST);
        AROUND_BLOCK.add(BlockFace.EAST);
        AROUND_BLOCK.add(BlockFace.SOUTH_EAST);
        AROUND_BLOCK.add(BlockFace.SOUTH);
        AROUND_BLOCK.add(BlockFace.SOUTH_WEST);
        AROUND_BLOCK.add(BlockFace.WEST);
        AROUND_BLOCK.add(BlockFace.NORTH_WEST);
    }
}

