/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils.metrics;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import com.onarandombox.MultiverseCore.utils.metrics.MetricsHelper;
import com.onarandombox.bstats.bukkit.Metrics;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang.WordUtils;
import org.bukkit.World;

public class MetricsConfigurator {
    private static final int PLUGIN_ID = 7765;
    private static final String NO_GENERATOR_NAME = "N/A";
    private final MultiverseCore plugin;
    private final Metrics metrics;

    public static void configureMetrics(MultiverseCore plugin) {
        MetricsConfigurator configurator = new MetricsConfigurator(plugin);
        configurator.initMetrics();
    }

    private MetricsConfigurator(MultiverseCore plugin) {
        this.plugin = plugin;
        this.metrics = new Metrics(plugin, 7765);
    }

    private MVWorldManager getWorldManager() {
        return this.plugin.getMVWorldManager();
    }

    private Collection<MultiverseWorld> getMVWorlds() {
        return this.getWorldManager().getMVWorlds();
    }

    private void initMetrics() {
        try {
            this.addCustomGeneratorsMetric();
            this.addEnvironmentsMetric();
            this.addWorldCountMetric();
            CoreLogging.fine("Metrics enabled.", new Object[0]);
        }
        catch (Exception e) {
            CoreLogging.warning("There was an issue while enabling metrics:", new Object[0]);
            e.printStackTrace();
        }
    }

    private void addCustomGeneratorsMetric() {
        this.addAdvancedPieMetric("custom_generators", map -> {
            for (MultiverseWorld w : this.getMVWorlds()) {
                MetricsHelper.incrementCount(map, this.getGeneratorName(w));
            }
        });
    }

    private String getGeneratorName(MultiverseWorld world) {
        String gen = world.getGenerator();
        return gen != null && !gen.equalsIgnoreCase("null") ? gen.split(":")[0] : NO_GENERATOR_NAME;
    }

    private void addEnvironmentsMetric() {
        this.addAdvancedPieMetric("environments", map -> {
            for (MultiverseWorld w : this.getMVWorlds()) {
                MetricsHelper.incrementCount(map, this.titleCaseEnv(w.getEnvironment()));
            }
        });
    }

    private String titleCaseEnv(World.Environment env) {
        String envName = env.name().replaceAll("_+", " ");
        return WordUtils.capitalizeFully(envName);
    }

    private void addWorldCountMetric() {
        this.addMultiLineMetric("world_count", map -> {
            int loadedWorldsCount = this.getMVWorlds().size();
            map.put("Loaded worlds", loadedWorldsCount);
            map.put("Total number of worlds", loadedWorldsCount + this.getWorldManager().getUnloadedWorlds().size());
        });
    }

    private void addAdvancedPieMetric(String chartId, Consumer<Map<String, Integer>> metricsFunc) {
        this.metrics.addCustomChart(MetricsHelper.createAdvancedPieChart(chartId, metricsFunc));
    }

    private void addMultiLineMetric(String chartId, Consumer<Map<String, Integer>> metricsFunc) {
        this.metrics.addCustomChart(MetricsHelper.createMultiLineChart(chartId, metricsFunc));
    }
}

