/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils.webpaste;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

abstract class HttpAPIClient {
    private final String url;
    private final String accessToken;

    HttpAPIClient(String url) {
        this(url, null);
    }

    HttpAPIClient(String url, String accessToken) {
        this.url = url;
        this.accessToken = accessToken;
    }

    private String getContentHeader(ContentType type) {
        switch (type) {
            case JSON: {
                return "application/json; charset=utf-8";
            }
            case PLAINTEXT: {
                return "text/plain; charset=utf-8";
            }
            case URLENCODED: {
                return "application/x-www-form-urlencoded; charset=utf-8";
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)type));
    }

    abstract String encodeData(String var1);

    abstract String encodeData(Map<String, String> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String exec(String payload, ContentType type) throws IOException {
        BufferedReader rd = null;
        OutputStreamWriter wr = null;
        try {
            String line;
            HttpsURLConnection conn = (HttpsURLConnection)new URL(this.url).openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.addRequestProperty("Accept", "*/*");
            conn.addRequestProperty("User-Agent", "placeholder");
            conn.addRequestProperty("Content-Type", this.getContentHeader(type));
            if (this.accessToken != null) {
                conn.addRequestProperty("Authorization", this.accessToken);
            }
            wr = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8.newEncoder());
            wr.write(payload);
            wr.flush();
            StringBuilder responseString = new StringBuilder();
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            while ((line = rd.readLine()) != null) {
                responseString.append(line);
            }
            String string = responseString.toString();
            return string;
        }
        finally {
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (IOException iOException) {}
            }
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static enum ContentType {
        JSON,
        PLAINTEXT,
        URLENCODED;

    }
}

