/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.buscript;

import com.onarandombox.buscript.FunctionNotFoundException;
import com.onarandombox.buscript.ScriptExecutor;
import com.onarandombox.buscript.StringReplacer;
import com.onarandombox.buscript.util.FileTools;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.bukkit.ChatColor;

public class ScriptManager {
    private final Logger logger;
    public static final String NULL = "!!NULL";
    private ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("nashorn");
    private Invocable invocable = (Invocable)((Object)this.scriptEngine);
    private ScriptContext defaultContext = this.scriptEngine.getContext();
    private Bindings engineBindings = this.defaultContext.getBindings(100);
    Object globalObject;
    Object objectConstructor;
    private String target = null;
    private File scriptFolder;
    private Map<String, String> scriptCache = new HashMap<String, String>();
    private List<Map<String, Object>> delayedReplacements = null;
    protected final List<StringReplacer> stringReplacers = new ArrayList<StringReplacer>();
    protected Map<String, Object> metaData = new HashMap<String, Object>();

    protected ScriptManager(File scriptFolder, Logger logger) {
        this.logger = logger;
        this.registerStringReplacer(new TargetReplacer(this));
        this.scriptFolder = scriptFolder;
        if (!this.getScriptFolder().exists()) {
            this.getScriptFolder().mkdirs();
        }
        try {
            this.globalObject = this.scriptEngine.eval("this");
            this.objectConstructor = this.scriptEngine.eval("Object");
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
        this.engineBindings.put("metaData", (Object)this.metaData);
        this.engineBindings.put("NULL", (Object)NULL);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public Object getGlobalScope() {
        return this.globalObject;
    }

    public String getTarget() {
        return this.target;
    }

    public File getScriptFolder() {
        return this.scriptFolder;
    }

    public void setScriptFolder(File folder) {
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("folder must be a directory!");
        }
        this.scriptFolder = folder;
    }

    public String stringReplace(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        String result = string;
        if (this.delayedReplacements != null) {
            for (Map<String, Object> replacement : this.delayedReplacements) {
                Object regex = replacement.get("regex");
                Object replace = replacement.get("replace");
                if (regex == null) continue;
                if (replace == null) {
                    replace = NULL;
                }
                result = result.replaceAll(regex.toString(), replace.toString());
            }
        } else {
            for (StringReplacer r : this.stringReplacers) {
                String regex = r.getRegexString();
                if (regex == null) continue;
                String replace = r.getReplacement();
                if (replace == null) {
                    replace = NULL;
                }
                result = result.replaceAll(regex, replace);
            }
        }
        result = ChatColor.translateAlternateColorCodes('&', result);
        return result;
    }

    public void registerStringReplacer(StringReplacer replacer) {
        Iterator<StringReplacer> it = this.stringReplacers.iterator();
        while (it.hasNext()) {
            StringReplacer r = it.next();
            if (!r.getRegexString().equals(replacer.getRegexString())) continue;
            it.remove();
        }
        this.stringReplacers.add(replacer);
    }

    public void addScriptMethods(Object obj) {
        try {
            this.invocable.invokeMethod(this.objectConstructor, "bindProperties", this.globalObject, obj);
        }
        catch (NoSuchMethodException | ScriptException e) {
            e.printStackTrace();
        }
    }

    public void setScriptVariable(String name, Object object) {
        this.engineBindings.put(name, object);
    }

    public Object getScriptVariable(String name) {
        return this.engineBindings.get(name);
    }

    public <T> T getScriptVariable(String name, Class<T> type) {
        try {
            return type.cast(this.getScriptVariable(name));
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public Object runScriptFunction(Object obj, String functionName, Object ... args) throws FunctionNotFoundException, ScriptException {
        Object o = this.getScriptVariable(functionName);
        try {
            return this.invocable.invokeMethod(obj, functionName, args);
        }
        catch (NoSuchMethodException e) {
            throw new FunctionNotFoundException("'" + functionName + "' is not a valid function!");
        }
    }

    Object executeDelayedScript(File scriptFile, List<Map<String, Object>> replacements, Map<String, Object> data) {
        if (data != null) {
            this.metaData = data;
        }
        this.delayedReplacements = replacements;
        Object res = this.executeScript(scriptFile, null, null);
        this.delayedReplacements = null;
        return res;
    }

    public Object executeScript(File scriptFile) {
        return this.executeScript(scriptFile, null, null);
    }

    public Object executeScript(File scriptFile, ScriptExecutor executor) {
        return this.executeScript(scriptFile, null, executor);
    }

    public Object executeScript(File scriptFile, String target) {
        return this.executeScript(scriptFile, target, null);
    }

    public Object executeScript(File scriptFile, String target, ScriptExecutor executor) {
        this.target = target;
        Object res = this.runScript(scriptFile, executor);
        this.target = null;
        this.metaData.clear();
        return res;
    }

    public Object executeScript(String script, String source) {
        return this.executeScript(script, source, null, null);
    }

    public Object executeScript(String script, String source, ScriptExecutor executor) {
        return this.executeScript(script, source, null, executor);
    }

    public Object executeScript(String script, String source, String target) {
        return this.executeScript(script, source, target, null);
    }

    public Object executeScript(String script, String source, String target, ScriptExecutor executor) {
        this.target = target;
        Object res = this.runScript(script, executor);
        this.target = null;
        this.metaData.clear();
        return res;
    }

    Object runScript(String script, ScriptExecutor executor) {
        this.setup();
        try {
            return this.scriptEngine.eval(script);
        }
        catch (ScriptException e) {
            this.getLogger().warning("Error running script: " + e.getMessage());
            if (executor != null) {
                executor.sendMessage("Error running script: " + e.getMessage());
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object runScript(File script, ScriptExecutor executor) {
        this.setup();
        try (FileReader reader = new FileReader(script);){
            Object object = this.scriptEngine.eval(reader);
            return object;
        }
        catch (IOException | ScriptException e) {
            this.getLogger().warning("Error running script: " + e.getMessage());
            if (executor == null) return null;
            executor.sendMessage("Error running script: " + e.getMessage());
            return null;
        }
    }

    private void setup() {
        if (this.delayedReplacements != null) {
            for (Map<String, Object> replacement : this.delayedReplacements) {
                Object var = replacement.get("var");
                Object replace = replacement.get("replace");
                if (var == null) continue;
                if (replace == null) {
                    replace = NULL;
                }
                this.setScriptVariable(var.toString(), replace);
            }
        } else {
            for (StringReplacer r : this.stringReplacers) {
                String var = r.getGlobalVarName();
                String replace = r.getReplacement();
                if (var == null) continue;
                if (replace == null) {
                    replace = NULL;
                }
                this.setScriptVariable(var, replace);
            }
        }
        this.setScriptVariable("metaData", this.metaData);
    }

    void cacheScript(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().warning(e.getMessage());
                return;
            }
        }
        this.scriptCache.put(fileName, FileTools.readFileAsString(file, this.getLogger()));
    }

    String getCachedScript(String fileName) {
        String cached = this.scriptCache.get(fileName);
        if (cached == null) {
            this.cacheScript(fileName);
            cached = this.scriptCache.get(fileName);
        }
        return cached != null ? cached : "";
    }

    public void clearScriptCache() {
        this.scriptCache.clear();
    }

    private static class TargetReplacer
    implements StringReplacer {
        private ScriptManager scriptManager;

        private TargetReplacer(ScriptManager scriptManager) {
            this.scriptManager = scriptManager;
        }

        @Override
        public String getRegexString() {
            return "%target%";
        }

        @Override
        public String getReplacement() {
            return this.scriptManager.getTarget();
        }

        @Override
        public String getGlobalVarName() {
            return "target";
        }
    }
}

