/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.commandhandler;

import com.lithium3141.shellparser.ShellParser;
import com.onarandombox.commandhandler.Command;
import com.onarandombox.commandhandler.CommandKey;
import com.onarandombox.commandhandler.PermissionsInterface;
import com.onarandombox.commandhandler.QueuedCommand;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class CommandHandler {
    protected Plugin plugin;
    protected List<QueuedCommand> queuedCommands;
    protected List<Command> allCommands;
    protected PermissionsInterface permissions;
    private Properties props = new Properties();
    private double version;

    public CommandHandler(Plugin plugin, PermissionsInterface permissions) {
        try {
            this.props.load(this.getClass().getResourceAsStream("/commandhandler.properties"));
            this.version = Integer.parseInt(this.props.getProperty("version", "-1"));
        }
        catch (NumberFormatException e) {
            this.logBadCH(plugin);
        }
        catch (FileNotFoundException e) {
            this.logBadCH(plugin);
        }
        catch (IOException e) {
            this.logBadCH(plugin);
        }
        this.plugin = plugin;
        this.allCommands = new ArrayList<Command>();
        this.queuedCommands = new ArrayList<QueuedCommand>();
        this.permissions = permissions;
    }

    private void logBadCH(Plugin plugin) {
        plugin.getLogger().log(Level.SEVERE, String.format("CommandHandler looks corrupted, meaning this plugin (%s) is corrupted too!", plugin.getDescription().getName()));
    }

    public double getVersion() {
        return this.version;
    }

    public List<Command> getCommands(CommandSender sender) {
        ArrayList<Command> permissiveCommands = new ArrayList<Command>();
        for (Command c : this.allCommands) {
            if (!this.permissions.hasAnyPermission(sender, c.getAllPermissionStrings(), c.isOpRequired())) continue;
            permissiveCommands.add(c);
        }
        return permissiveCommands;
    }

    public List<Command> getAllCommands() {
        return this.allCommands;
    }

    public boolean locateAndRunCommand(CommandSender sender, List<String> args) {
        return this.locateAndRunCommand(sender, args, true);
    }

    public boolean locateAndRunCommand(CommandSender sender, List<String> args, boolean notifySender) {
        List<String> parsedArgs = this.parseAllQuotedStrings(args);
        CommandKey key = null;
        Iterator<Command> iterator = this.allCommands.iterator();
        Command foundCommand = null;
        ArrayList<Command> foundCommands = new ArrayList<Command>();
        ArrayList<CommandKey> foundKeys = new ArrayList<CommandKey>();
        while (iterator.hasNext()) {
            foundCommand = iterator.next();
            key = foundCommand.getKey(parsedArgs);
            if (key == null) continue;
            foundCommands.add(foundCommand);
            foundKeys.add(key);
        }
        this.processFoundCommands(foundCommands, foundKeys, sender, parsedArgs, notifySender);
        return true;
    }

    private void processFoundCommands(List<Command> foundCommands, List<CommandKey> foundKeys, CommandSender sender, List<String> parsedArgs) {
        this.processFoundCommands(foundCommands, foundKeys, sender, parsedArgs, true);
    }

    private void processFoundCommands(List<Command> foundCommands, List<CommandKey> foundKeys, CommandSender sender, List<String> parsedArgs, boolean notifySender) {
        if (foundCommands.size() == 0) {
            return;
        }
        Command bestMatch = null;
        CommandKey matchingKey = null;
        int bestMatchInt = 0;
        for (int i = 0; i < foundCommands.size(); ++i) {
            ArrayList<String> parsedCopy = new ArrayList<String>(parsedArgs);
            foundCommands.get(i).removeKeyArgs(parsedCopy, foundKeys.get(i).getKey());
            if (foundCommands.get(i).getNumKeyArgs(foundKeys.get(i).getKey()) > bestMatchInt) {
                bestMatch = foundCommands.get(i);
                matchingKey = foundKeys.get(i);
                bestMatchInt = bestMatch.getNumKeyArgs(matchingKey.getKey());
                continue;
            }
            if (foundCommands.get(i).getNumKeyArgs(foundKeys.get(i).getKey()) != bestMatchInt || !foundKeys.get(i).hasValidNumberOfArgs(parsedCopy.size())) continue;
            bestMatch = foundCommands.get(i);
            matchingKey = foundKeys.get(i);
        }
        if (bestMatch != null) {
            bestMatch.removeKeyArgs(parsedArgs, matchingKey.getKey());
            if (parsedArgs.size() == 1 && parsedArgs.get(0).equals("?") && this.permissions.hasAnyPermission(sender, bestMatch.getAllPermissionStrings(), bestMatch.isOpRequired())) {
                bestMatch.showHelp(sender);
            } else {
                this.checkAndRunCommand(sender, parsedArgs, bestMatch, notifySender);
            }
        }
    }

    public void registerCommand(Command command) {
        this.allCommands.add(command);
    }

    private List<String> parseAllQuotedStrings(List<String> args) {
        String arg = null;
        if (args.size() == 0) {
            arg = "";
        } else {
            arg = args.get(0);
            for (int i = 1; i < args.size(); ++i) {
                arg = arg + " " + args.get(i);
            }
        }
        List<String> result = ShellParser.safeParseString(arg);
        if (result == null) {
            return new ArrayList<String>();
        }
        return result;
    }

    public void queueCommand(CommandSender sender, String commandName, String methodName, List<? extends Object> args, Class<?>[] paramTypes, String message, String message2, String success, String fail, int seconds) {
        this.cancelQueuedCommand(sender);
        this.queuedCommands.add(new QueuedCommand(methodName, args, paramTypes, sender, Calendar.getInstance(), this.plugin, success, fail, seconds));
        message = message == null ? "The command " + (Object)((Object)ChatColor.RED) + commandName + (Object)((Object)ChatColor.WHITE) + " has been halted due to the fact that it could break something!" : message.replace("{CMD}", (Object)((Object)ChatColor.RED) + commandName + (Object)((Object)ChatColor.WHITE));
        message2 = message2 == null ? "If you still wish to execute " + (Object)((Object)ChatColor.RED) + commandName + (Object)((Object)ChatColor.WHITE) : message2.replace("{CMD}", (Object)((Object)ChatColor.RED) + commandName + (Object)((Object)ChatColor.WHITE));
        sender.sendMessage(message);
        sender.sendMessage(message2);
        sender.sendMessage("please type: " + (Object)((Object)ChatColor.GREEN) + "/mvconfirm");
        sender.sendMessage((Object)((Object)ChatColor.GREEN) + "/mvconfirm" + (Object)((Object)ChatColor.WHITE) + " will only be available for " + seconds + " seconds.");
    }

    public void queueCommand(CommandSender sender, String commandName, String methodName, List<? extends Object> args, Class<?>[] paramTypes, String success, String fail) {
        this.queueCommand(sender, commandName, methodName, args, paramTypes, null, null, success, fail, 10);
    }

    public boolean confirmQueuedCommand(CommandSender sender) {
        for (QueuedCommand com : this.queuedCommands) {
            if (!com.getSender().equals(sender)) continue;
            if (com.execute()) {
                if (com.getSuccess() != null && com.getSuccess().length() > 0) {
                    sender.sendMessage(com.getSuccess());
                }
                return true;
            }
            if (com.getFail() == null || com.getFail().length() <= 0) continue;
            sender.sendMessage(com.getFail());
            return false;
        }
        return false;
    }

    public void cancelQueuedCommand(CommandSender sender) {
        QueuedCommand c = null;
        for (QueuedCommand com : this.queuedCommands) {
            if (!com.getSender().equals(sender)) continue;
            c = com;
        }
        if (c != null) {
            this.queuedCommands.remove(c);
        }
    }

    public static String getFlag(String flag, List<String> args) {
        int i = 0;
        try {
            for (String s : args) {
                if (s.equalsIgnoreCase(flag)) {
                    return args.get(i + 1);
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    public static boolean hasFlag(String flag, List<String> args) {
        for (String s : args) {
            if (!s.equalsIgnoreCase(flag)) continue;
            return true;
        }
        return false;
    }

    private void checkAndRunCommand(CommandSender sender, List<String> parsedArgs, Command foundCommand, boolean notifySender) {
        if (this.permissions.hasAnyPermission(sender, foundCommand.getAllPermissionStrings(), foundCommand.isOpRequired())) {
            if (foundCommand.checkArgLength(parsedArgs)) {
                foundCommand.runCommand(sender, parsedArgs);
            } else {
                foundCommand.showHelp(sender);
            }
        } else if (notifySender) {
            sender.sendMessage("You do not have any of the required permission(s):");
            for (String perm : foundCommand.getAllPermissionStrings()) {
                sender.sendMessage(" - " + (Object)((Object)ChatColor.GREEN) + perm);
            }
        }
    }

    private void checkAndRunCommand(CommandSender sender, List<String> parsedArgs, Command foundCommand) {
        this.checkAndRunCommand(sender, parsedArgs, foundCommand, true);
    }
}

