/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.entity.metadata.EntityProperties;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Boat;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Golem;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.minecart.ExplosiveMinecart;

class BukkitEntityProperties
implements EntityProperties {
    private static final boolean HAS_ABSTRACT_VILLAGER;
    private final Entity entity;

    BukkitEntityProperties(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        this.entity = entity;
    }

    public boolean isPlayerDerived() {
        return this.entity instanceof HumanEntity;
    }

    public boolean isProjectile() {
        return this.entity instanceof Projectile;
    }

    public boolean isItem() {
        return this.entity instanceof Item;
    }

    public boolean isFallingBlock() {
        return this.entity instanceof FallingBlock;
    }

    public boolean isPainting() {
        return this.entity instanceof Painting;
    }

    public boolean isItemFrame() {
        return this.entity instanceof ItemFrame;
    }

    public boolean isBoat() {
        return this.entity instanceof Boat;
    }

    public boolean isMinecart() {
        return this.entity instanceof Minecart;
    }

    public boolean isTNT() {
        return this.entity instanceof TNTPrimed || this.entity instanceof ExplosiveMinecart;
    }

    public boolean isExperienceOrb() {
        return this.entity instanceof ExperienceOrb;
    }

    public boolean isLiving() {
        return this.entity instanceof LivingEntity;
    }

    public boolean isAnimal() {
        return this.entity instanceof Animals;
    }

    public boolean isAmbient() {
        return this.entity instanceof Ambient;
    }

    public boolean isNPC() {
        if (HAS_ABSTRACT_VILLAGER) {
            return this.entity instanceof AbstractVillager;
        }
        return this.entity instanceof Villager;
    }

    public boolean isGolem() {
        return this.entity instanceof Golem;
    }

    public boolean isTamed() {
        return this.entity instanceof Tameable && ((Tameable)this.entity).isTamed();
    }

    public boolean isTagged() {
        return this.entity instanceof LivingEntity && this.entity.getCustomName() != null;
    }

    public boolean isArmorStand() {
        return this.entity instanceof ArmorStand;
    }

    public boolean isPasteable() {
        return !(this.entity instanceof Player) && !(this.entity instanceof ComplexEntityPart);
    }

    static {
        boolean temp;
        try {
            Class.forName("org.bukkit.entity.AbstractVillager");
            temp = true;
        }
        catch (ClassNotFoundException e) {
            temp = false;
        }
        HAS_ABSTRACT_VILLAGER = temp;
    }
}

