/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EditSessionFactory;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxBrushRadiusException;
import com.sk89q.worldedit.MaxRadiusException;
import com.sk89q.worldedit.UnknownDirectionException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.BlockInteractEvent;
import com.sk89q.worldedit.event.platform.InputType;
import com.sk89q.worldedit.event.platform.Interaction;
import com.sk89q.worldedit.event.platform.PlayerInputEvent;
import com.sk89q.worldedit.extension.factory.BlockFactory;
import com.sk89q.worldedit.extension.factory.ItemFactory;
import com.sk89q.worldedit.extension.factory.MaskFactory;
import com.sk89q.worldedit.extension.factory.PatternFactory;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.PlatformManager;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.scripting.CraftScriptContext;
import com.sk89q.worldedit.scripting.RhinoCraftScriptEngine;
import com.sk89q.worldedit.session.SessionManager;
import com.sk89q.worldedit.session.request.Request;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.eventbus.EventBus;
import com.sk89q.worldedit.util.io.file.FileSelectionAbortedException;
import com.sk89q.worldedit.util.io.file.FilenameException;
import com.sk89q.worldedit.util.io.file.FilenameResolutionException;
import com.sk89q.worldedit.util.io.file.InvalidFilenameException;
import com.sk89q.worldedit.util.logging.WorldEditPrefixHandler;
import com.sk89q.worldedit.util.task.SimpleSupervisor;
import com.sk89q.worldedit.util.task.Supervisor;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.registry.BundledBlockData;
import com.sk89q.worldedit.world.registry.BundledItemData;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.script.ScriptException;

public class WorldEdit {
    public static final Logger logger = Logger.getLogger(WorldEdit.class.getCanonicalName());
    private static final WorldEdit instance = new WorldEdit();
    private static String version;
    private final EventBus eventBus = new EventBus();
    private final PlatformManager platformManager = new PlatformManager(this);
    private final EditSessionFactory editSessionFactory = new EditSessionFactory.EditSessionFactoryImpl(this.eventBus);
    private final SessionManager sessions = new SessionManager(this);
    private final Supervisor supervisor = new SimpleSupervisor();
    private final BlockFactory blockFactory = new BlockFactory(this);
    private final ItemFactory itemFactory = new ItemFactory(this);
    private final MaskFactory maskFactory = new MaskFactory(this);
    private final PatternFactory patternFactory = new PatternFactory(this);

    private WorldEdit() {
    }

    public static WorldEdit getInstance() {
        return instance;
    }

    public PlatformManager getPlatformManager() {
        return this.platformManager;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public Supervisor getSupervisor() {
        return this.supervisor;
    }

    public BlockFactory getBlockFactory() {
        return this.blockFactory;
    }

    public ItemFactory getItemFactory() {
        return this.itemFactory;
    }

    public MaskFactory getMaskFactory() {
        return this.maskFactory;
    }

    public PatternFactory getPatternFactory() {
        return this.patternFactory;
    }

    public SessionManager getSessionManager() {
        return this.sessions;
    }

    public File getSafeSaveFile(Player player, File dir, String filename, String defaultExt, String ... extensions) throws FilenameException {
        return this.getSafeFile(player, dir, filename, defaultExt, extensions, true);
    }

    public File getSafeOpenFile(Player player, File dir, String filename, String defaultExt, String ... extensions) throws FilenameException {
        return this.getSafeFile(player, dir, filename, defaultExt, extensions, false);
    }

    private File getSafeFile(@Nullable Player player, File dir, String filename, String defaultExt, String[] extensions, boolean isSave) throws FilenameException {
        File f;
        if (extensions != null && extensions.length == 1 && extensions[0] == null) {
            extensions = null;
        }
        if (filename.equals("#") && player != null) {
            f = isSave ? player.openFileSaveDialog(extensions) : player.openFileOpenDialog(extensions);
            if (f == null) {
                throw new FileSelectionAbortedException("No file selected");
            }
        } else {
            Object exts = extensions == null ? ImmutableList.of((Object)defaultExt) : Lists.asList((Object)defaultExt, (Object[])extensions);
            return this.getSafeFileWithExtensions(dir, filename, (List<String>)exts, isSave);
        }
        try {
            String filePath = f.getCanonicalPath();
            String dirPath = dir.getCanonicalPath();
            if (!filePath.substring(0, dirPath.length()).equals(dirPath) && !this.getConfiguration().allowSymlinks) {
                throw new FilenameResolutionException(filename, "Path is outside allowable root");
            }
            return f;
        }
        catch (IOException e) {
            throw new FilenameResolutionException(filename, "Failed to resolve path");
        }
    }

    private File getSafeFileWithExtensions(File dir, String filename, List<String> exts, boolean isSave) throws InvalidFilenameException {
        if (isSave && exts.size() != 1) {
            exts = exts.subList(0, 1);
        }
        File result = null;
        Iterator<String> iter = exts.iterator();
        while (iter.hasNext() && (result == null || !result.exists())) {
            result = this.getSafeFileWithExtension(dir, filename, iter.next());
        }
        if (result == null) {
            throw new InvalidFilenameException(filename, "Invalid characters or extension missing");
        }
        return result;
    }

    private File getSafeFileWithExtension(File dir, String filename, String extension) {
        if (extension != null && filename.lastIndexOf(46) == -1) {
            filename = filename + "." + extension;
        }
        if (!this.checkFilename(filename)) {
            return null;
        }
        return new File(dir, filename);
    }

    private boolean checkFilename(String filename) {
        return filename.matches("^[A-Za-z0-9_\\- \\./\\\\'\\$@~!%\\^\\*\\(\\)\\[\\]\\+\\{\\},\\?]+\\.[A-Za-z0-9]+$");
    }

    public void loadMappings() {
        BundledBlockData.getInstance();
        BundledItemData.getInstance();
        LegacyMapper.getInstance();
    }

    public void checkMaxRadius(double radius) throws MaxRadiusException {
        if (this.getConfiguration().maxRadius > 0 && radius > (double)this.getConfiguration().maxRadius) {
            throw new MaxRadiusException();
        }
    }

    public void checkMaxBrushRadius(double radius) throws MaxBrushRadiusException {
        if (this.getConfiguration().maxBrushRadius > 0 && radius > (double)this.getConfiguration().maxBrushRadius) {
            throw new MaxBrushRadiusException();
        }
    }

    public File getWorkingDirectoryFile(String path) {
        File f = new File(path);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(this.getConfiguration().getWorkingDirectory(), path);
    }

    public BlockVector3 getDirection(Player player, String dirStr) throws UnknownDirectionException {
        Direction dir = this.getPlayerDirection(player, dirStr = dirStr.toLowerCase());
        if (dir.isUpright() || dir.isCardinal()) {
            return dir.toBlockVector();
        }
        throw new UnknownDirectionException(dir.name());
    }

    public BlockVector3 getDiagonalDirection(Player player, String dirStr) throws UnknownDirectionException {
        Direction dir = this.getPlayerDirection(player, dirStr = dirStr.toLowerCase());
        if (dir.isCardinal() || dir.isOrdinal() || dir.isUpright()) {
            return dir.toBlockVector();
        }
        throw new UnknownDirectionException(dir.name());
    }

    private Direction getPlayerDirection(Player player, String dirStr) throws UnknownDirectionException {
        Direction dir;
        switch (dirStr.charAt(0)) {
            case 'w': {
                dir = Direction.WEST;
                break;
            }
            case 'e': {
                dir = Direction.EAST;
                break;
            }
            case 's': {
                if (dirStr.indexOf(119) > 0) {
                    return Direction.SOUTHWEST;
                }
                if (dirStr.indexOf(101) > 0) {
                    return Direction.SOUTHEAST;
                }
                dir = Direction.SOUTH;
                break;
            }
            case 'n': {
                if (dirStr.indexOf(119) > 0) {
                    return Direction.NORTHWEST;
                }
                if (dirStr.indexOf(101) > 0) {
                    return Direction.NORTHEAST;
                }
                dir = Direction.NORTH;
                break;
            }
            case 'u': {
                dir = Direction.UP;
                break;
            }
            case 'd': {
                dir = Direction.DOWN;
                break;
            }
            case 'f': 
            case 'm': {
                dir = player.getCardinalDirection(0);
                break;
            }
            case 'b': {
                dir = player.getCardinalDirection(180);
                break;
            }
            case 'l': {
                dir = player.getCardinalDirection(-90);
                break;
            }
            case 'r': {
                dir = player.getCardinalDirection(90);
                break;
            }
            default: {
                throw new UnknownDirectionException(dirStr);
            }
        }
        return dir;
    }

    public void flushBlockBag(Actor actor, EditSession editSession) {
        Map<BlockType, Integer> missingBlocks;
        BlockBag blockBag = editSession.getBlockBag();
        if (blockBag != null) {
            blockBag.flushChanges();
        }
        if (!(missingBlocks = editSession.popMissingBlocks()).isEmpty()) {
            StringBuilder str = new StringBuilder();
            str.append("Missing these blocks: ");
            int size = missingBlocks.size();
            int i = 0;
            for (Map.Entry<BlockType, Integer> blockTypeIntegerEntry : missingBlocks.entrySet()) {
                str.append(blockTypeIntegerEntry.getKey().getName());
                str.append(" [Amt: ").append(blockTypeIntegerEntry.getValue()).append("]");
                if (++i == size) continue;
                str.append(", ");
            }
            actor.printError(str.toString());
        }
    }

    public boolean handleArmSwing(Player player) {
        PlayerInputEvent event = new PlayerInputEvent(player, InputType.PRIMARY);
        this.getEventBus().post(event);
        return event.isCancelled();
    }

    public boolean handleRightClick(Player player) {
        PlayerInputEvent event = new PlayerInputEvent(player, InputType.SECONDARY);
        this.getEventBus().post(event);
        return event.isCancelled();
    }

    public boolean handleBlockRightClick(Player player, Location clicked) {
        BlockInteractEvent event = new BlockInteractEvent(player, clicked, Interaction.OPEN);
        this.getEventBus().post(event);
        return event.isCancelled();
    }

    public boolean handleBlockLeftClick(Player player, Location clicked) {
        BlockInteractEvent event = new BlockInteractEvent(player, clicked, Interaction.HIT);
        this.getEventBus().post(event);
        return event.isCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(Player player, File f, String[] args) throws WorldEditException {
        RhinoCraftScriptEngine engine;
        String script;
        Request.reset();
        String filename = f.getPath();
        int index = filename.lastIndexOf(46);
        String ext = filename.substring(index + 1);
        if (!ext.equalsIgnoreCase("js")) {
            player.printError("Only .js scripts are currently supported");
            return;
        }
        try {
            InputStream file;
            if (!f.exists()) {
                file = WorldEdit.class.getResourceAsStream("craftscripts/" + filename);
                if (file == null) {
                    player.printError("Script does not exist: " + filename);
                    return;
                }
            } else {
                file = new FileInputStream(f);
            }
            DataInputStream in = new DataInputStream(file);
            byte[] data = new byte[in.available()];
            in.readFully(data);
            in.close();
            script = new String(data, 0, data.length, "utf-8");
        }
        catch (IOException e) {
            player.printError("Script read error: " + e.getMessage());
            return;
        }
        LocalSession session = this.getSessionManager().get(player);
        CraftScriptContext scriptContext = new CraftScriptContext(this, this.getPlatformManager().queryCapability(Capability.USER_COMMANDS), this.getConfiguration(), session, player, args);
        try {
            engine = new RhinoCraftScriptEngine();
        }
        catch (NoClassDefFoundError e) {
            player.printError("Failed to find an installed script engine.");
            player.printError("Please see http://wiki.sk89q.com/wiki/WorldEdit/Installation");
            return;
        }
        engine.setTimeLimit(this.getConfiguration().scriptTimeout);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("argv", args);
        vars.put("context", scriptContext);
        vars.put("player", player);
        try {
            engine.evaluate(script, filename, vars);
        }
        catch (ScriptException e) {
            player.printError("Failed to execute:");
            player.printRaw(e.getMessage());
            logger.log(Level.WARNING, "Failed to execute script", e);
        }
        catch (WorldEditException | NumberFormatException e) {
            throw e;
        }
        catch (Throwable e) {
            player.printError("Failed to execute (see console):");
            player.printRaw(e.getClass().getCanonicalName());
            logger.log(Level.WARNING, "Failed to execute script", e);
        }
        finally {
            for (EditSession editSession : scriptContext.getEditSessions()) {
                editSession.flushSession();
                session.remember(editSession);
            }
        }
    }

    public LocalConfiguration getConfiguration() {
        return this.getPlatformManager().getConfiguration();
    }

    public EditSessionFactory getEditSessionFactory() {
        return this.editSessionFactory;
    }

    public static String getVersion() {
        if (version != null) {
            return version;
        }
        Package p = WorldEdit.class.getPackage();
        if (p == null) {
            p = Package.getPackage("com.sk89q.worldedit");
        }
        if (p == null) {
            version = "(unknown)";
        } else {
            version = p.getImplementationVersion();
            if (version == null) {
                version = "(unknown)";
            }
        }
        return version;
    }

    static {
        WorldEditPrefixHandler.register("com.sk89q.worldedit");
        WorldEdit.getVersion();
    }
}

