/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Joiner;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CreatureButcher;
import com.sk89q.worldedit.command.util.EntityRemover;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.CommandManager;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.EntityVisitor;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.internal.expression.runtime.EvaluationException;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.CylinderRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.command.CommandCallable;
import com.sk89q.worldedit.util.command.CommandMapping;
import com.sk89q.worldedit.util.command.Dispatcher;
import com.sk89q.worldedit.util.command.PrimaryAliasComparator;
import com.sk89q.worldedit.util.command.binding.Text;
import com.sk89q.worldedit.util.formatting.ColorCodeBuilder;
import com.sk89q.worldedit.util.formatting.Style;
import com.sk89q.worldedit.util.formatting.StyledFragment;
import com.sk89q.worldedit.util.formatting.component.Code;
import com.sk89q.worldedit.util.formatting.component.CommandListBox;
import com.sk89q.worldedit.util.formatting.component.CommandUsageBox;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class UtilityCommands {
    private final WorldEdit we;

    public UtilityCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"/fill"}, usage="<block> <radius> [depth]", desc="Fill a hole", min=2, max=3)
    @CommandPermissions(value={"worldedit.fill"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void fill(Player player, LocalSession session, EditSession editSession, CommandContext args) throws WorldEditException {
        ParserContext context = new ParserContext();
        context.setActor(player);
        context.setWorld(player.getWorld());
        context.setSession(session);
        Pattern pattern = (Pattern)this.we.getPatternFactory().parseFromInput(args.getString(0), context);
        double radius = Math.max(1.0, args.getDouble(1));
        this.we.checkMaxRadius(radius);
        int depth = args.argsLength() > 2 ? Math.max(1, args.getInteger(2)) : 1;
        BlockVector3 pos = session.getPlacementPosition(player);
        int affected = editSession.fillXZ(pos, pattern, radius, depth, false);
        player.print(affected + " block(s) have been created.");
    }

    @Command(aliases={"/fillr"}, usage="<block> <radius> [depth]", desc="Fill a hole recursively", min=2, max=3)
    @CommandPermissions(value={"worldedit.fill.recursive"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void fillr(Player player, LocalSession session, EditSession editSession, CommandContext args) throws WorldEditException {
        ParserContext context = new ParserContext();
        context.setActor(player);
        context.setWorld(player.getWorld());
        context.setSession(session);
        Pattern pattern = (Pattern)this.we.getPatternFactory().parseFromInput(args.getString(0), context);
        double radius = Math.max(1.0, args.getDouble(1));
        this.we.checkMaxRadius(radius);
        int depth = args.argsLength() > 2 ? Math.max(1, args.getInteger(2)) : Integer.MAX_VALUE;
        BlockVector3 pos = session.getPlacementPosition(player);
        int affected = 0;
        affected = pattern instanceof BlockPattern ? editSession.fillXZ(pos, ((BlockPattern)pattern).getBlock(), radius, depth, true) : editSession.fillXZ(pos, pattern, radius, depth, true);
        player.print(affected + " block(s) have been created.");
    }

    @Command(aliases={"/drain"}, usage="<radius>", desc="Drain a pool", min=1, max=1)
    @CommandPermissions(value={"worldedit.drain"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void drain(Player player, LocalSession session, EditSession editSession, CommandContext args) throws WorldEditException {
        double radius = Math.max(0.0, args.getDouble(0));
        this.we.checkMaxRadius(radius);
        int affected = editSession.drainArea(session.getPlacementPosition(player), radius);
        player.print(affected + " block(s) have been changed.");
    }

    @Command(aliases={"/fixlava", "fixlava"}, usage="<radius>", desc="Fix lava to be stationary", min=1, max=1)
    @CommandPermissions(value={"worldedit.fixlava"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void fixLava(Player player, LocalSession session, EditSession editSession, CommandContext args) throws WorldEditException {
        double radius = Math.max(0.0, args.getDouble(0));
        this.we.checkMaxRadius(radius);
        int affected = editSession.fixLiquid(session.getPlacementPosition(player), radius, BlockTypes.LAVA);
        player.print(affected + " block(s) have been changed.");
    }

    @Command(aliases={"/fixwater", "fixwater"}, usage="<radius>", desc="Fix water to be stationary", min=1, max=1)
    @CommandPermissions(value={"worldedit.fixwater"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void fixWater(Player player, LocalSession session, EditSession editSession, CommandContext args) throws WorldEditException {
        double radius = Math.max(0.0, args.getDouble(0));
        this.we.checkMaxRadius(radius);
        int affected = editSession.fixLiquid(session.getPlacementPosition(player), radius, BlockTypes.WATER);
        player.print(affected + " block(s) have been changed.");
    }

    @Command(aliases={"/removeabove", "removeabove"}, usage="[size] [height]", desc="Remove blocks above your head.", min=0, max=2)
    @CommandPermissions(value={"worldedit.removeabove"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void removeAbove(Player player, LocalSession session, EditSession editSession, CommandContext args) throws WorldEditException {
        int size = args.argsLength() > 0 ? Math.max(1, args.getInteger(0)) : 1;
        this.we.checkMaxRadius(size);
        World world = player.getWorld();
        int height = args.argsLength() > 1 ? Math.min(world.getMaxY() + 1, args.getInteger(1) + 2) : world.getMaxY() + 1;
        int affected = editSession.removeAbove(session.getPlacementPosition(player), size, height);
        player.print(affected + " block(s) have been removed.");
    }

    @Command(aliases={"/removebelow", "removebelow"}, usage="[size] [height]", desc="Remove blocks below you.", min=0, max=2)
    @CommandPermissions(value={"worldedit.removebelow"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void removeBelow(Player player, LocalSession session, EditSession editSession, CommandContext args) throws WorldEditException {
        int size = args.argsLength() > 0 ? Math.max(1, args.getInteger(0)) : 1;
        this.we.checkMaxRadius(size);
        World world = player.getWorld();
        int height = args.argsLength() > 1 ? Math.min(world.getMaxY() + 1, args.getInteger(1) + 2) : world.getMaxY() + 1;
        int affected = editSession.removeBelow(session.getPlacementPosition(player), size, height);
        player.print(affected + " block(s) have been removed.");
    }

    @Command(aliases={"/removenear", "removenear"}, usage="<block> [size]", desc="Remove blocks near you.", min=1, max=2)
    @CommandPermissions(value={"worldedit.removenear"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void removeNear(Player player, LocalSession session, EditSession editSession, CommandContext args) throws WorldEditException {
        ParserContext context = new ParserContext();
        context.setActor(player);
        context.setWorld(player.getWorld());
        context.setSession(session);
        context.setRestricted(false);
        context.setPreferringWildcard(false);
        BlockStateHolder block = (BlockStateHolder)this.we.getBlockFactory().parseFromInput(args.getString(0), context);
        int size = Math.max(1, args.getInteger(1, 50));
        this.we.checkMaxRadius(size);
        int affected = editSession.removeNear(session.getPlacementPosition(player), block.getBlockType(), size);
        player.print(affected + " block(s) have been removed.");
    }

    @Command(aliases={"/replacenear", "replacenear"}, usage="<size> <from-id> <to-id>", desc="Replace nearby blocks", flags="f", min=3, max=3)
    @CommandPermissions(value={"worldedit.replacenear"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void replaceNear(Player player, LocalSession session, EditSession editSession, CommandContext args) throws WorldEditException {
        Pattern to;
        Set<BlockStateHolder> from;
        int size = Math.max(1, args.getInteger(0));
        ParserContext context = new ParserContext();
        context.setActor(player);
        context.setWorld(player.getWorld());
        context.setSession(session);
        context.setRestricted(false);
        context.setPreferringWildcard(!args.hasFlag('f'));
        if (args.argsLength() == 2) {
            from = null;
            to = (Pattern)this.we.getPatternFactory().parseFromInput(args.getString(1), context);
        } else {
            from = this.we.getBlockFactory().parseFromListInput(args.getString(1), context);
            to = (Pattern)this.we.getPatternFactory().parseFromInput(args.getString(2), context);
        }
        BlockVector3 base = session.getPlacementPosition(player);
        BlockVector3 min = base.subtract(size, size, size);
        BlockVector3 max = base.add(size, size, size);
        CuboidRegion region = new CuboidRegion(player.getWorld(), min, max);
        int affected = to instanceof BlockPattern ? editSession.replaceBlocks((Region)region, from, ((BlockPattern)to).getBlock()) : editSession.replaceBlocks((Region)region, from, to);
        player.print(affected + " block(s) have been replaced.");
    }

    @Command(aliases={"/snow", "snow"}, usage="[radius]", desc="Simulates snow", min=0, max=1)
    @CommandPermissions(value={"worldedit.snow"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void snow(Player player, LocalSession session, EditSession editSession, CommandContext args) throws WorldEditException {
        double size = args.argsLength() > 0 ? Math.max(1.0, args.getDouble(0)) : 10.0;
        int affected = editSession.simulateSnow(session.getPlacementPosition(player), size);
        player.print(affected + " surfaces covered. Let it snow~");
    }

    @Command(aliases={"/thaw", "thaw"}, usage="[radius]", desc="Thaws the area", min=0, max=1)
    @CommandPermissions(value={"worldedit.thaw"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void thaw(Player player, LocalSession session, EditSession editSession, CommandContext args) throws WorldEditException {
        double size = args.argsLength() > 0 ? Math.max(1.0, args.getDouble(0)) : 10.0;
        int affected = editSession.thaw(session.getPlacementPosition(player), size);
        player.print(affected + " surfaces thawed.");
    }

    @Command(aliases={"/green", "green"}, usage="[radius]", desc="Greens the area", flags="f", min=0, max=1)
    @CommandPermissions(value={"worldedit.green"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void green(Player player, LocalSession session, EditSession editSession, CommandContext args) throws WorldEditException {
        double size = args.argsLength() > 0 ? Math.max(1.0, args.getDouble(0)) : 10.0;
        boolean onlyNormalDirt = !args.hasFlag('f');
        int affected = editSession.green(session.getPlacementPosition(player), size, onlyNormalDirt);
        player.print(affected + " surfaces greened.");
    }

    @Command(aliases={"/ex", "/ext", "/extinguish", "ex", "ext", "extinguish"}, usage="[radius]", desc="Extinguish nearby fire", min=0, max=1)
    @CommandPermissions(value={"worldedit.extinguish"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void extinguish(Player player, LocalSession session, EditSession editSession, CommandContext args) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        int defaultRadius = config.maxRadius != -1 ? Math.min(40, config.maxRadius) : 40;
        int size = args.argsLength() > 0 ? Math.max(1, args.getInteger(0)) : defaultRadius;
        this.we.checkMaxRadius(size);
        int affected = editSession.removeNear(session.getPlacementPosition(player), BlockTypes.FIRE, size);
        player.print(affected + " block(s) have been removed.");
    }

    @Command(aliases={"butcher"}, usage="[radius]", flags="plangbtfr", desc="Kill all or nearby mobs", help="Kills nearby mobs, based on radius, if none is given uses default in configuration.\nFlags:\n  -p also kills pets.\n  -n also kills NPCs.\n  -g also kills Golems.\n  -a also kills animals.\n  -b also kills ambient mobs.\n  -t also kills mobs with name tags.\n  -f compounds all previous flags.\n  -r also destroys armor stands.\n  -l currently does nothing.", min=0, max=1)
    @CommandPermissions(value={"worldedit.butcher"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void butcher(Actor actor, CommandContext args) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        Player player = actor instanceof Player ? (Player)actor : null;
        int radius = config.butcherDefaultRadius;
        if (args.argsLength() > 0) {
            radius = args.getInteger(0);
            if (radius < -1) {
                actor.printError("Use -1 to remove all mobs in loaded chunks");
                return;
            }
            if (config.butcherMaxRadius != -1) {
                radius = radius == -1 ? config.butcherMaxRadius : Math.min(radius, config.butcherMaxRadius);
            }
        }
        CreatureButcher flags = new CreatureButcher(actor);
        flags.fromCommand(args);
        ArrayList<EntityVisitor> visitors = new ArrayList<EntityVisitor>();
        LocalSession session = null;
        EditSession editSession = null;
        if (player != null) {
            List<? extends Entity> entities;
            session = this.we.getSessionManager().get(player);
            BlockVector3 center = session.getPlacementPosition(player);
            editSession = session.createEditSession(player);
            if (radius >= 0) {
                CylinderRegion cylinderRegion = CylinderRegion.createRadius(editSession, center, radius);
                entities = editSession.getEntities(cylinderRegion);
            } else {
                entities = editSession.getEntities();
            }
            visitors.add(new EntityVisitor(entities.iterator(), flags.createFunction()));
        } else {
            Platform platform = this.we.getPlatformManager().queryCapability(Capability.WORLD_EDITING);
            for (World world : platform.getWorlds()) {
                List<? extends Entity> entities = world.getEntities();
                visitors.add(new EntityVisitor(entities.iterator(), flags.createFunction()));
            }
        }
        int killed = 0;
        for (EntityVisitor entityVisitor : visitors) {
            Operations.completeLegacy(entityVisitor);
            killed += entityVisitor.getAffected();
        }
        actor.print("Killed " + killed + (killed != 1 ? " mobs" : " mob") + (radius < 0 ? "" : " in a radius of " + radius) + ".");
        if (editSession != null) {
            session.remember(editSession);
            editSession.flushSession();
        }
    }

    @Command(aliases={"remove", "rem", "rement"}, usage="<type> <radius>", desc="Remove all entities of a type", min=2, max=2)
    @CommandPermissions(value={"worldedit.remove"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void remove(Actor actor, CommandContext args) throws WorldEditException, CommandException {
        Player player;
        String typeStr = args.getString(0);
        int radius = args.getInteger(1);
        Player player2 = player = actor instanceof Player ? (Player)actor : null;
        if (radius < -1) {
            actor.printError("Use -1 to remove all entities in loaded chunks");
            return;
        }
        EntityRemover remover = new EntityRemover();
        remover.fromString(typeStr);
        ArrayList<EntityVisitor> visitors = new ArrayList<EntityVisitor>();
        LocalSession session = null;
        EditSession editSession = null;
        if (player != null) {
            List<? extends Entity> entities;
            session = this.we.getSessionManager().get(player);
            BlockVector3 center = session.getPlacementPosition(player);
            editSession = session.createEditSession(player);
            if (radius >= 0) {
                CylinderRegion cylinderRegion = CylinderRegion.createRadius(editSession, center, radius);
                entities = editSession.getEntities(cylinderRegion);
            } else {
                entities = editSession.getEntities();
            }
            visitors.add(new EntityVisitor(entities.iterator(), remover.createFunction()));
        } else {
            Platform platform = this.we.getPlatformManager().queryCapability(Capability.WORLD_EDITING);
            for (World world : platform.getWorlds()) {
                List<? extends Entity> entities = world.getEntities();
                visitors.add(new EntityVisitor(entities.iterator(), remover.createFunction()));
            }
        }
        int removed = 0;
        for (EntityVisitor entityVisitor : visitors) {
            Operations.completeLegacy(entityVisitor);
            removed += entityVisitor.getAffected();
        }
        actor.print("Marked " + removed + (removed != 1 ? " entities" : " entity") + " for removal.");
        if (editSession != null) {
            session.remember(editSession);
            editSession.flushSession();
        }
    }

    @Command(aliases={"/calc", "/calculate", "/eval", "/evaluate", "/solve"}, usage="<expression>", desc="Evaluate a mathematical expression")
    @CommandPermissions(value={"worldedit.calc"})
    public void calc(Actor actor, @Text String input) throws CommandException {
        try {
            Expression expression = Expression.compile(input, new String[0]);
            actor.print("= " + expression.evaluate(new double[0]));
        }
        catch (EvaluationException e) {
            actor.printError(String.format("'%s' could not be parsed as a valid expression", input));
        }
        catch (ExpressionException e) {
            actor.printError(String.format("'%s' could not be evaluated (error: %s)", input, e.getMessage()));
        }
    }

    @Command(aliases={"/help"}, usage="[<command>]", desc="Displays help for WorldEdit commands", min=0, max=-1)
    @CommandPermissions(value={"worldedit.help"})
    public void help(Actor actor, CommandContext args) throws WorldEditException {
        UtilityCommands.help(args, this.we, actor);
    }

    private static CommandMapping detectCommand(Dispatcher dispatcher, String command, boolean isRootLevel) {
        CommandMapping mapping = dispatcher.get(command);
        if (mapping != null) {
            return mapping;
        }
        if (isRootLevel && !command.contains("/")) {
            mapping = dispatcher.get("//" + command);
            if (mapping != null) {
                return mapping;
            }
            mapping = dispatcher.get("/" + command);
            if (mapping != null) {
                return mapping;
            }
        }
        return null;
    }

    public static void help(CommandContext args, WorldEdit we, Actor actor) {
        CommandCallable callable = we.getPlatformManager().getCommandManager().getDispatcher();
        int page = 0;
        int perPage = actor instanceof Player ? 8 : 20;
        int effectiveLength = args.argsLength();
        try {
            if (args.argsLength() > 0) {
                page = args.getInteger(args.argsLength() - 1);
                page = page <= 0 ? 1 : --page;
                --effectiveLength;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        boolean isRootLevel = true;
        ArrayList<String> visited = new ArrayList<String>();
        for (int i = 0; i < effectiveLength; ++i) {
            String command = args.getString(i);
            if (callable instanceof Dispatcher) {
                CommandMapping mapping;
                if (isRootLevel && command.length() > 1 && command.charAt(0) == '/') {
                    command = command.substring(1);
                }
                if ((mapping = UtilityCommands.detectCommand(callable, command, isRootLevel)) == null) {
                    if (isRootLevel) {
                        actor.printError(String.format("The command '%s' could not be found.", args.getString(i)));
                        return;
                    }
                    actor.printError(String.format("The sub-command '%s' under '%s' could not be found.", command, Joiner.on((String)" ").join(visited)));
                    return;
                }
                callable = mapping.getCallable();
            } else {
                actor.printError(String.format("'%s' has no sub-commands. (Maybe '%s' is for a parameter?)", Joiner.on((String)" ").join(visited), command));
                return;
            }
            visited.add(args.getString(i));
            isRootLevel = false;
        }
        if (callable instanceof Dispatcher) {
            Dispatcher dispatcher = callable;
            ArrayList<CommandMapping> aliases = new ArrayList<CommandMapping>(dispatcher.getCommands());
            aliases.sort(new PrimaryAliasComparator(CommandManager.COMMAND_CLEAN_PATTERN));
            int offset = perPage * page;
            int pageTotal = (int)Math.ceil((double)aliases.size() / (double)perPage);
            CommandListBox box = new CommandListBox(String.format("Help: page %d/%d ", page + 1, pageTotal));
            StyledFragment contents = box.getContents();
            StyledFragment tip = contents.createFragment(Style.GRAY);
            if (offset >= aliases.size()) {
                tip.createFragment(Style.RED).append(String.format("There is no page %d (total number of pages is %d).", page + 1, pageTotal)).newLine();
            } else {
                List list = aliases.subList(offset, Math.min(offset + perPage, aliases.size()));
                tip.append("Type ");
                tip.append(new Code().append("//help ").append("<command> [<page>]"));
                tip.append(" for more information.").newLine();
                for (CommandMapping mapping : list) {
                    StringBuilder builder = new StringBuilder();
                    if (isRootLevel) {
                        builder.append("/");
                    }
                    if (!visited.isEmpty()) {
                        builder.append(Joiner.on((String)" ").join(visited));
                        builder.append(" ");
                    }
                    builder.append(mapping.getPrimaryAlias());
                    box.appendCommand(builder.toString(), mapping.getDescription().getDescription());
                }
            }
            actor.printRaw(ColorCodeBuilder.asColorCodes(box));
        } else {
            CommandUsageBox box = new CommandUsageBox(callable, Joiner.on((String)" ").join(visited));
            actor.printRaw(ColorCodeBuilder.asColorCodes(box));
        }
    }
}

