/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.tool;

import com.google.common.collect.Lists;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.command.tool.DoubleActionBlockTool;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class BlockDataCyler
implements DoubleActionBlockTool {
    private Map<UUID, Property<?>> selectedProperties = new HashMap();

    @Override
    public boolean canUse(Actor player) {
        return player.hasPermission("worldedit.tool.data-cycler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleCycle(Platform server, LocalConfiguration config, Player player, LocalSession session, Location clicked, boolean forward) {
        World world = (World)clicked.getExtent();
        BlockVector3 blockPoint = clicked.toVector().toBlockPoint();
        BlockState block = world.getBlock(blockPoint);
        if (!(config.allowedDataCycleBlocks.isEmpty() || player.hasPermission("worldedit.override.data-cycler") || config.allowedDataCycleBlocks.contains(block.getBlockType().getId()))) {
            player.printError("You are not permitted to cycle the data value of that block.");
            return true;
        }
        if (block.getStates().keySet().isEmpty()) {
            player.printError("That block's data cannot be cycled!");
        } else {
            Property currentProperty = this.selectedProperties.get(player.getUniqueId());
            if (currentProperty == null || forward && block.getState(currentProperty) == null) {
                currentProperty = (Property)block.getStates().keySet().stream().findFirst().get();
                this.selectedProperties.put(player.getUniqueId(), currentProperty);
            }
            if (forward) {
                block.getState(currentProperty);
                int index = currentProperty.getValues().indexOf(block.getState(currentProperty));
                index = (index + 1) % currentProperty.getValues().size();
                BlockStateHolder newBlock = block.with(currentProperty, currentProperty.getValues().get(index));
                try (EditSession editSession = session.createEditSession(player);){
                    editSession.disableBuffering();
                    try {
                        editSession.setBlock(blockPoint, newBlock);
                        player.print("Value of " + currentProperty.getName() + " is now " + currentProperty.getValues().get(index).toString());
                    }
                    catch (MaxChangedBlocksException e) {
                        player.printError("Max blocks change limit reached.");
                    }
                    finally {
                        session.remember(editSession);
                    }
                }
            } else {
                ArrayList properties = Lists.newArrayList(block.getStates().keySet());
                int index = properties.indexOf(currentProperty);
                index = (index + 1) % properties.size();
                currentProperty = (Property)properties.get(index);
                this.selectedProperties.put(player.getUniqueId(), currentProperty);
                player.print("Now cycling " + currentProperty.getName());
            }
        }
        return true;
    }

    @Override
    public boolean actPrimary(Platform server, LocalConfiguration config, Player player, LocalSession session, Location clicked) {
        return this.handleCycle(server, config, player, session, clicked, true);
    }

    @Override
    public boolean actSecondary(Platform server, LocalConfiguration config, Player player, LocalSession session, Location clicked) {
        return this.handleCycle(server, config, player, session, clicked, false);
    }
}

