/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.tool.brush;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.Collections;

public class GravityBrush
implements Brush {
    private final boolean fullHeight;

    public GravityBrush(boolean fullHeight) {
        this.fullHeight = fullHeight;
    }

    @Override
    public void build(EditSession editSession, BlockVector3 position, Pattern pattern, double size) throws MaxChangedBlocksException {
        double startY = this.fullHeight ? (double)editSession.getWorld().getMaxY() : (double)position.getBlockY() + size;
        for (double x = (double)position.getBlockX() + size; x > (double)position.getBlockX() - size; x -= 1.0) {
            for (double z = (double)position.getBlockZ() + size; z > (double)position.getBlockZ() - size; z -= 1.0) {
                BlockVector3 pt;
                double y;
                ArrayList<BlockState> blockTypes = new ArrayList<BlockState>();
                for (y = startY; y > (double)position.getBlockY() - size; y -= 1.0) {
                    pt = BlockVector3.at(x, y, z);
                    BlockState block = editSession.getBlock(pt);
                    if (block.getBlockType().getMaterial().isAir()) continue;
                    blockTypes.add(block);
                    editSession.setBlock(pt, BlockTypes.AIR.getDefaultState());
                }
                pt = BlockVector3.at(x, y, z);
                Collections.reverse(blockTypes);
                int i = 0;
                while (i < blockTypes.size()) {
                    if (editSession.getBlock(pt).getBlockType().getMaterial().isAir()) {
                        editSession.setBlock(pt, (BlockStateHolder)blockTypes.get(i++));
                    }
                    pt = pt.add(0, 1, 0);
                }
            }
        }
    }
}

