/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.sk89q.worldedit.command.util.FutureProgressListener;
import com.sk89q.worldedit.command.util.MessageFutureCallback;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.command.parametric.ExceptionConverter;
import com.sk89q.worldedit.util.task.FutureForwardingTask;
import com.sk89q.worldedit.util.task.Supervisor;
import com.sk89q.worldedit.world.World;
import javax.annotation.Nullable;

public class AsyncCommandHelper {
    private final ListenableFuture<?> future;
    private final Supervisor supervisor;
    private final Actor sender;
    private final ExceptionConverter exceptionConverter;
    @Nullable
    private Object[] formatArgs;

    private AsyncCommandHelper(ListenableFuture<?> future, Supervisor supervisor, Actor sender, ExceptionConverter exceptionConverter) {
        Preconditions.checkNotNull(future);
        Preconditions.checkNotNull((Object)supervisor);
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)exceptionConverter);
        this.future = future;
        this.supervisor = supervisor;
        this.sender = sender;
        this.exceptionConverter = exceptionConverter;
    }

    public AsyncCommandHelper formatUsing(Object ... args) {
        this.formatArgs = args;
        return this;
    }

    private String format(String message) {
        if (this.formatArgs != null) {
            return String.format(message, this.formatArgs);
        }
        return message;
    }

    public AsyncCommandHelper registerWithSupervisor(String description) {
        this.supervisor.monitor(FutureForwardingTask.create(this.future, this.format(description), this.sender));
        return this;
    }

    public AsyncCommandHelper sendMessageAfterDelay(String message) {
        FutureProgressListener.addProgressListener(this.future, this.sender, this.format(message));
        return this;
    }

    public AsyncCommandHelper thenRespondWith(String success, String failure) {
        Futures.addCallback(this.future, new MessageFutureCallback.Builder(this.sender).exceptionConverter(this.exceptionConverter).onSuccess(this.format(success)).onFailure(this.format(failure)).build());
        return this;
    }

    public AsyncCommandHelper thenTellErrorsOnly(String failure) {
        Futures.addCallback(this.future, new MessageFutureCallback.Builder(this.sender).exceptionConverter(this.exceptionConverter).onFailure(this.format(failure)).build());
        return this;
    }

    public AsyncCommandHelper forRegionDataLoad(World world, boolean silent) {
        Preconditions.checkNotNull((Object)world);
        this.formatUsing(world.getName());
        this.registerWithSupervisor("Loading region data for '%s'");
        if (silent) {
            this.thenTellErrorsOnly("Failed to load regions '%s'");
        } else {
            this.sendMessageAfterDelay("(Please wait... loading the region data for '%s')");
            this.thenRespondWith("Loaded region data for '%s'", "Failed to load regions '%s'");
        }
        return this;
    }

    public AsyncCommandHelper forRegionDataSave(World world, boolean silent) {
        Preconditions.checkNotNull((Object)world);
        this.formatUsing(world.getName());
        this.registerWithSupervisor("Saving region data for '%s'");
        if (silent) {
            this.thenTellErrorsOnly("Failed to save regions '%s'");
        } else {
            this.sendMessageAfterDelay("(Please wait... saving the region data for '%s')");
            this.thenRespondWith("Saved region data for '%s'", "Failed to load regions '%s'");
        }
        return this;
    }

    public static AsyncCommandHelper wrap(ListenableFuture<?> future, Supervisor supervisor, Actor sender, ExceptionConverter exceptionConverter) {
        return new AsyncCommandHelper(future, supervisor, sender, exceptionConverter);
    }
}

