/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.command.parametric.ExceptionConverter;
import javax.annotation.Nullable;

public class MessageFutureCallback<V>
implements FutureCallback<V> {
    private final ExceptionConverter exceptionConverter;
    private final Actor sender;
    @Nullable
    private final String success;
    @Nullable
    private final String failure;

    private MessageFutureCallback(ExceptionConverter exceptionConverter, Actor sender, @Nullable String success, @Nullable String failure) {
        this.exceptionConverter = exceptionConverter;
        this.sender = sender;
        this.success = success;
        this.failure = failure;
    }

    public void onSuccess(@Nullable V v) {
        if (this.success != null) {
            this.sender.print(this.success);
        }
    }

    public void onFailure(@Nullable Throwable throwable) {
        try {
            this.exceptionConverter.convert(throwable);
        }
        catch (CommandException e) {
            String failure = this.failure != null ? this.failure : "An error occurred";
            String message = e.getMessage() != null ? e.getMessage() : "An unknown error occurred. Please see the console!";
            this.sender.printError(failure + ": " + message);
        }
    }

    public static <V> MessageFutureCallback<V> createRegionLoadCallback(ExceptionConverter exceptionConverter, Actor sender) {
        return new Builder(sender).exceptionConverter(exceptionConverter).onSuccess("Successfully load the region data.").build();
    }

    public static <V> MessageFutureCallback<V> createRegionSaveCallback(ExceptionConverter exceptionConverter, Actor sender) {
        return new Builder(sender).exceptionConverter(exceptionConverter).onSuccess("Successfully saved the region data.").build();
    }

    public static class Builder {
        private final Actor sender;
        @Nullable
        private String success;
        @Nullable
        private String failure;
        private ExceptionConverter exceptionConverter;

        public Builder(Actor sender) {
            Preconditions.checkNotNull((Object)sender);
            this.sender = sender;
        }

        public Builder exceptionConverter(ExceptionConverter exceptionConverter) {
            this.exceptionConverter = exceptionConverter;
            return this;
        }

        public Builder onSuccess(@Nullable String message) {
            this.success = message;
            return this;
        }

        public Builder onFailure(@Nullable String message) {
            this.failure = message;
            return this;
        }

        public <V> MessageFutureCallback<V> build() {
            Preconditions.checkNotNull((Object)this.exceptionConverter);
            return new MessageFutureCallback(this.exceptionConverter, this.sender, this.success, this.failure);
        }
    }
}

