/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.factory.parser;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.internal.registry.InputParser;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.registry.LegacyMapper;

public class DefaultItemParser
extends InputParser<BaseItem> {
    public DefaultItemParser(WorldEdit worldEdit) {
        super(worldEdit);
    }

    @Override
    public BaseItem parseFromInput(String input, ParserContext context) throws InputParseException {
        ItemType type;
        BaseItem item = null;
        if (context.isTryingLegacy()) {
            try {
                String[] split = input.split(":");
                ItemType type2 = split.length == 1 ? LegacyMapper.getInstance().getItemFromLegacy(Integer.parseInt(split[0])) : LegacyMapper.getInstance().getItemFromLegacy(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
                item = new BaseItem(type2);
            }
            catch (NumberFormatException split) {
                // empty catch block
            }
        }
        if (item == null && (type = ItemTypes.get(input.toLowerCase())) != null) {
            item = new BaseItem(type);
        }
        if (item == null) {
            throw new InputParseException("'" + input + "' did not match any item");
        }
        return item;
    }
}

