/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.factory.parser.mask;

import com.google.common.base.Splitter;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.function.mask.BiomeMask2D;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.internal.registry.InputParser;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.biome.Biomes;
import com.sk89q.worldedit.world.registry.BiomeRegistry;
import java.util.HashSet;
import java.util.List;

public class BiomeMaskParser
extends InputParser<Mask> {
    public BiomeMaskParser(WorldEdit worldEdit) {
        super(worldEdit);
    }

    @Override
    public Mask parseFromInput(String input, ParserContext context) throws InputParseException {
        if (!input.startsWith("$")) {
            return null;
        }
        HashSet<BaseBiome> biomes = new HashSet<BaseBiome>();
        BiomeRegistry biomeRegistry = this.worldEdit.getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getBiomeRegistry();
        List<BaseBiome> knownBiomes = biomeRegistry.getBiomes();
        for (String biomeName : Splitter.on((String)",").split((CharSequence)input.substring(1))) {
            BaseBiome biome = Biomes.findBiomeByName(knownBiomes, biomeName, biomeRegistry);
            if (biome == null) {
                throw new InputParseException("Unknown biome '" + biomeName + '\'');
            }
            biomes.add(biome);
        }
        return Masks.asMask(new BiomeMask2D(context.requireExtent(), biomes));
    }
}

