/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.factory.parser.pattern;

import com.google.common.collect.Lists;
import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.pattern.ClipboardPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.registry.SimpleInputParser;
import com.sk89q.worldedit.session.ClipboardHolder;
import java.util.List;

public class ClipboardPatternParser
extends SimpleInputParser<Pattern> {
    public ClipboardPatternParser(WorldEdit worldEdit) {
        super(worldEdit);
    }

    @Override
    public List<String> getMatchedAliases() {
        return Lists.newArrayList((Object[])new String[]{"#clipboard", "#copy"});
    }

    @Override
    public Pattern parseFromSimpleInput(String input, ParserContext context) throws InputParseException {
        LocalSession session = context.requireSession();
        if (session != null) {
            try {
                ClipboardHolder holder = session.getClipboard();
                Clipboard clipboard = holder.getClipboard();
                return new ClipboardPattern(clipboard);
            }
            catch (EmptyClipboardException e) {
                throw new InputParseException("To use #clipboard, please first copy something to your clipboard");
            }
        }
        throw new InputParseException("No session is available, so no clipboard is available");
    }
}

