/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.platform;

import com.sk89q.worldedit.NotABlockException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TargetBlock;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.io.File;

public abstract class AbstractPlayerActor
implements Actor,
Player,
Cloneable {
    @Override
    public final Extent getExtent() {
        return this.getWorld();
    }

    private static Direction getDirection(double rot) {
        if (0.0 <= rot && rot < 22.5) {
            return Direction.SOUTH;
        }
        if (22.5 <= rot && rot < 67.5) {
            return Direction.SOUTHWEST;
        }
        if (67.5 <= rot && rot < 112.5) {
            return Direction.WEST;
        }
        if (112.5 <= rot && rot < 157.5) {
            return Direction.NORTHWEST;
        }
        if (157.5 <= rot && rot < 202.5) {
            return Direction.NORTH;
        }
        if (202.5 <= rot && rot < 247.5) {
            return Direction.NORTHEAST;
        }
        if (247.5 <= rot && rot < 292.5) {
            return Direction.EAST;
        }
        if (292.5 <= rot && rot < 337.5) {
            return Direction.SOUTHEAST;
        }
        if (337.5 <= rot && rot < 360.0) {
            return Direction.SOUTH;
        }
        return null;
    }

    @Override
    public boolean isHoldingPickAxe() {
        ItemType item = this.getItemInHand(HandSide.MAIN_HAND).getType();
        return item == ItemTypes.IRON_PICKAXE || item == ItemTypes.WOODEN_PICKAXE || item == ItemTypes.STONE_PICKAXE || item == ItemTypes.DIAMOND_PICKAXE || item == ItemTypes.GOLDEN_PICKAXE;
    }

    @Override
    public void findFreePosition(Location searchPos) {
        int y;
        Extent world = searchPos.getExtent();
        int x = searchPos.getBlockX();
        int origY = y = Math.max(0, searchPos.getBlockY());
        int z = searchPos.getBlockZ();
        int free = 0;
        while (y <= world.getMaximumPoint().getBlockY() + 2) {
            free = !world.getBlock(BlockVector3.at(x, y, z)).getBlockType().getMaterial().isMovementBlocker() ? (int)((byte)(free + 1)) : 0;
            if (free == 2) {
                if (y - 1 != origY) {
                    this.setPosition(Vector3.at((double)x + 0.5, y - 2 + 1, (double)z + 0.5));
                }
                return;
            }
            ++y;
        }
    }

    @Override
    public void setOnGround(Location searchPos) {
        Extent world = searchPos.getExtent();
        int x = searchPos.getBlockX();
        int z = searchPos.getBlockZ();
        for (int y = Math.max(0, searchPos.getBlockY()); y >= 0; --y) {
            BlockVector3 pos = BlockVector3.at(x, y, z);
            BlockState id = world.getBlock(pos);
            if (!id.getBlockType().getMaterial().isMovementBlocker()) continue;
            this.setPosition(Vector3.at((double)x + 0.5, y + 1, (double)z + 0.5));
            return;
        }
    }

    @Override
    public void findFreePosition() {
        this.findFreePosition(this.getBlockIn());
    }

    @Override
    public boolean ascendLevel() {
        Location pos = this.getBlockIn();
        int x = pos.getBlockX();
        int z = pos.getBlockZ();
        Extent world = pos.getExtent();
        int free = 0;
        int spots = 0;
        for (int y = Math.max(0, pos.getBlockY()); y <= world.getMaximumPoint().getY() + 2; ++y) {
            free = !world.getBlock(BlockVector3.at(x, y, z)).getBlockType().getMaterial().isMovementBlocker() ? (int)((byte)(free + 1)) : 0;
            if (free != 2 || (spots = (int)((byte)(spots + 1))) != 2) continue;
            BlockVector3 platform = BlockVector3.at(x, y - 2, z);
            BlockState block = world.getBlock(platform);
            BlockType type = block.getBlockType();
            if (type == BlockTypes.LAVA) {
                return false;
            }
            this.setPosition(platform.toVector3().add(0.5, 1.0, 0.5));
            return true;
        }
        return false;
    }

    @Override
    public boolean descendLevel() {
        Location pos = this.getBlockIn();
        int x = pos.getBlockX();
        int z = pos.getBlockZ();
        Extent world = pos.getExtent();
        int free = 0;
        for (int y = Math.max(0, pos.getBlockY() - 1); y >= 1; --y) {
            free = !world.getBlock(BlockVector3.at(x, y, z)).getBlockType().getMaterial().isMovementBlocker() ? (int)((byte)(free + 1)) : 0;
            if (free != 2) continue;
            while (y >= 0) {
                BlockVector3 platform = BlockVector3.at(x, y, z);
                BlockState block = world.getBlock(platform);
                BlockType type = block.getBlockType();
                if (!type.getMaterial().isAir() && type != BlockTypes.LAVA) {
                    this.setPosition(platform.toVector3().add(0.5, 1.0, 0.5));
                    return true;
                }
                --y;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean ascendToCeiling(int clearance) {
        return this.ascendToCeiling(clearance, true);
    }

    @Override
    public boolean ascendToCeiling(int clearance, boolean alwaysGlass) {
        int y;
        Location pos = this.getBlockIn();
        int x = pos.getBlockX();
        int initialY = Math.max(0, pos.getBlockY());
        int z = pos.getBlockZ();
        Extent world = this.getLocation().getExtent();
        if (!world.getBlock(BlockVector3.at(x, y, z)).getBlockType().getMaterial().isAir()) {
            return false;
        }
        for (y = Math.max(0, pos.getBlockY() + 2); y <= world.getMaximumPoint().getY(); ++y) {
            if (!world.getBlock(BlockVector3.at(x, y, z)).getBlockType().getMaterial().isMovementBlocker()) continue;
            int platformY = Math.max(initialY, y - 3 - clearance);
            this.floatAt(x, platformY + 1, z, alwaysGlass);
            return true;
        }
        return false;
    }

    @Override
    public boolean ascendUpwards(int distance) {
        return this.ascendUpwards(distance, true);
    }

    @Override
    public boolean ascendUpwards(int distance, boolean alwaysGlass) {
        Location pos = this.getBlockIn();
        int x = pos.getBlockX();
        int initialY = Math.max(0, pos.getBlockY());
        int z = pos.getBlockZ();
        int maxY = Math.min(this.getWorld().getMaxY() + 1, initialY + distance);
        Extent world = this.getLocation().getExtent();
        for (int y = Math.max(0, pos.getBlockY() + 1); y <= world.getMaximumPoint().getY() + 2 && !world.getBlock(BlockVector3.at(x, y, z)).getBlockType().getMaterial().isMovementBlocker() && y <= maxY + 1; ++y) {
            if (y != maxY + 1) continue;
            this.floatAt(x, y - 1, z, alwaysGlass);
            return true;
        }
        return false;
    }

    @Override
    public void floatAt(int x, int y, int z, boolean alwaysGlass) {
        try {
            BlockVector3 spot = BlockVector3.at(x, y - 1, z);
            if (!this.getLocation().getExtent().getBlock(spot).getBlockType().getMaterial().isMovementBlocker()) {
                this.getLocation().getExtent().setBlock(spot, BlockTypes.GLASS.getDefaultState());
            }
        }
        catch (WorldEditException e) {
            e.printStackTrace();
        }
        this.setPosition(Vector3.at((double)x + 0.5, y, (double)z + 0.5));
    }

    @Override
    public Location getBlockIn() {
        return this.getLocation().setPosition(this.getLocation().toVector().floor());
    }

    @Override
    public Location getBlockOn() {
        return this.getLocation().setPosition(this.getLocation().setY(this.getLocation().getY() - 1.0).toVector().floor());
    }

    @Override
    public Location getBlockTrace(int range, boolean useLastBlock) {
        TargetBlock tb = new TargetBlock(this, range, 0.2);
        return useLastBlock ? tb.getAnyTargetBlock() : tb.getTargetBlock();
    }

    @Override
    public Location getBlockTraceFace(int range, boolean useLastBlock) {
        TargetBlock tb = new TargetBlock(this, range, 0.2);
        return useLastBlock ? tb.getAnyTargetBlockFace() : tb.getTargetBlockFace();
    }

    @Override
    public Location getBlockTrace(int range) {
        return this.getBlockTrace(range, false);
    }

    @Override
    public Location getSolidBlockTrace(int range) {
        TargetBlock tb = new TargetBlock(this, range, 0.2);
        return tb.getSolidTargetBlock();
    }

    @Override
    public Direction getCardinalDirection() {
        return this.getCardinalDirection(0);
    }

    @Override
    public Direction getCardinalDirection(int yawOffset) {
        if ((double)this.getLocation().getPitch() > 67.5) {
            return Direction.DOWN;
        }
        if ((double)this.getLocation().getPitch() < -67.5) {
            return Direction.UP;
        }
        double rot = (this.getLocation().getYaw() + (float)yawOffset) % 360.0f;
        if (rot < 0.0) {
            rot += 360.0;
        }
        return AbstractPlayerActor.getDirection(rot);
    }

    @Override
    public BaseBlock getBlockInHand(HandSide handSide) throws WorldEditException {
        ItemType typeId = this.getItemInHand(handSide).getType();
        if (typeId.hasBlockType()) {
            return typeId.getBlockType().getDefaultState().toBaseBlock();
        }
        throw new NotABlockException();
    }

    @Override
    public boolean passThroughForwardWall(int range) {
        Location block;
        int searchDist = 0;
        TargetBlock hitBlox = new TargetBlock(this, range, 0.2);
        Extent world = this.getLocation().getExtent();
        boolean firstBlock = true;
        int freeToFind = 2;
        boolean inFree = false;
        while ((block = hitBlox.getNextBlock()) != null) {
            boolean free;
            boolean bl = free = !world.getBlock(block.toVector().toBlockPoint()).getBlockType().getMaterial().isMovementBlocker();
            if (firstBlock) {
                firstBlock = false;
                if (!free) {
                    --freeToFind;
                    continue;
                }
            }
            if (++searchDist > 20) {
                return false;
            }
            if (inFree != free && free) {
                --freeToFind;
            }
            if (freeToFind == 0) {
                this.setOnGround(block);
                return true;
            }
            inFree = free;
        }
        return false;
    }

    @Override
    public void setPosition(Vector3 pos) {
        this.setPosition(pos, this.getLocation().getPitch(), this.getLocation().getYaw());
    }

    @Override
    public File openFileOpenDialog(String[] extensions) {
        this.printError("File dialogs are not supported in your environment.");
        return null;
    }

    @Override
    public File openFileSaveDialog(String[] extensions) {
        this.printError("File dialogs are not supported in your environment.");
        return null;
    }

    @Override
    public boolean canDestroyBedrock() {
        return this.hasPermission("worldedit.override.bedrock");
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
    }

    public boolean equals(Object other) {
        if (!(other instanceof Player)) {
            return false;
        }
        Player other2 = (Player)other;
        return other2.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public void checkPermission(String permission) throws AuthorizationException {
        if (!this.hasPermission(permission)) {
            throw new AuthorizationException();
        }
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    @Override
    public GameMode getGameMode() {
        return GameModes.SURVIVAL;
    }

    @Override
    public void setGameMode(GameMode gameMode) {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Not supported");
    }

    @Override
    public boolean remove() {
        return false;
    }

    @Override
    public void sendFakeBlock(BlockVector3 pos, BlockStateHolder block) {
    }
}

