/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.buffer;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ForgetfulExtentBuffer
extends AbstractDelegateExtent
implements Pattern {
    private final Map<BlockVector3, BlockStateHolder> buffer = new LinkedHashMap<BlockVector3, BlockStateHolder>();
    private final Mask mask;
    private BlockVector3 min = null;
    private BlockVector3 max = null;

    public ForgetfulExtentBuffer(Extent delegate) {
        this(delegate, Masks.alwaysTrue());
    }

    public ForgetfulExtentBuffer(Extent delegate, Mask mask) {
        super(delegate);
        Preconditions.checkNotNull((Object)delegate);
        Preconditions.checkNotNull((Object)mask);
        this.mask = mask;
    }

    @Override
    public boolean setBlock(BlockVector3 location, BlockStateHolder block) throws WorldEditException {
        this.min = this.min == null ? location : this.min.getMinimum(location);
        this.max = this.max == null ? location : this.max.getMaximum(location);
        BlockVector3 blockVector = location;
        if (this.mask.test(blockVector)) {
            this.buffer.put(blockVector, block);
            return true;
        }
        return this.getExtent().setBlock(location, block);
    }

    @Override
    public BlockStateHolder apply(BlockVector3 pos) {
        BlockStateHolder block = this.buffer.get(pos);
        if (block != null) {
            return block;
        }
        return BlockTypes.AIR.getDefaultState();
    }

    public Region asRegion() {
        return new AbstractRegion(null){

            @Override
            public BlockVector3 getMinimumPoint() {
                return ForgetfulExtentBuffer.this.min != null ? ForgetfulExtentBuffer.this.min : BlockVector3.ZERO;
            }

            @Override
            public BlockVector3 getMaximumPoint() {
                return ForgetfulExtentBuffer.this.max != null ? ForgetfulExtentBuffer.this.max : BlockVector3.ZERO;
            }

            @Override
            public void expand(BlockVector3 ... changes) throws RegionOperationException {
                throw new UnsupportedOperationException("Cannot change the size of this region");
            }

            @Override
            public void contract(BlockVector3 ... changes) throws RegionOperationException {
                throw new UnsupportedOperationException("Cannot change the size of this region");
            }

            @Override
            public boolean contains(BlockVector3 position) {
                return ForgetfulExtentBuffer.this.buffer.containsKey(position);
            }

            @Override
            public Iterator<BlockVector3> iterator() {
                return ForgetfulExtentBuffer.this.buffer.keySet().iterator();
            }
        };
    }
}

