/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.cache;

import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockState;

public class LastAccessExtentCache
extends AbstractDelegateExtent {
    private CachedBlock lastBlock;

    public LastAccessExtentCache(Extent extent) {
        super(extent);
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        CachedBlock lastBlock = this.lastBlock;
        if (lastBlock != null && lastBlock.position.equals(position)) {
            return lastBlock.block;
        }
        BlockState block = super.getBlock(position);
        this.lastBlock = new CachedBlock(position, block);
        return block;
    }

    private static class CachedBlock {
        private final BlockVector3 position;
        private final BlockState block;

        private CachedBlock(BlockVector3 position, BlockState block) {
            this.position = position;
            this.block = block;
        }
    }
}

