/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NamedTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.NBTSchematicReader;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.NBTCompatibilityHandler;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.SignCompatibilityHandler;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import com.sk89q.worldedit.world.storage.NBTConversions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MCEditSchematicReader
extends NBTSchematicReader {
    private static final List<NBTCompatibilityHandler> COMPATIBILITY_HANDLERS = new ArrayList<NBTCompatibilityHandler>();
    private static final Logger log;
    private final NBTInputStream inputStream;

    public MCEditSchematicReader(NBTInputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        this.inputStream = inputStream;
    }

    @Override
    public Clipboard read() throws IOException {
        CuboidRegion region;
        BlockVector3 origin;
        NamedTag rootTag = this.inputStream.readNamedTag();
        if (!rootTag.getName().equals("Schematic")) {
            throw new IOException("Tag 'Schematic' does not exist or is not first");
        }
        CompoundTag schematicTag = (CompoundTag)rootTag.getTag();
        Object schematic = schematicTag.getValue();
        if (!schematic.containsKey("Blocks")) {
            throw new IOException("Schematic file is missing a 'Blocks' tag");
        }
        String materials = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "Materials", StringTag.class).getValue();
        if (!materials.equals("Alpha")) {
            throw new IOException("Schematic file is not an Alpha schematic");
        }
        int width = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "Width", ShortTag.class).getValue().shortValue();
        int height = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "Height", ShortTag.class).getValue().shortValue();
        int length = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "Length", ShortTag.class).getValue().shortValue();
        try {
            int originX = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "WEOriginX", IntTag.class).getValue();
            int originY = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "WEOriginY", IntTag.class).getValue();
            int originZ = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "WEOriginZ", IntTag.class).getValue();
            BlockVector3 min = BlockVector3.at(originX, originY, originZ);
            int offsetX = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "WEOffsetX", IntTag.class).getValue();
            int offsetY = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "WEOffsetY", IntTag.class).getValue();
            int offsetZ = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "WEOffsetZ", IntTag.class).getValue();
            BlockVector3 offset = BlockVector3.at(offsetX, offsetY, offsetZ);
            origin = min.subtract(offset);
            region = new CuboidRegion(min, min.add(width, height, length).subtract(BlockVector3.ONE));
        }
        catch (IOException ignored) {
            origin = BlockVector3.ZERO;
            region = new CuboidRegion(origin, origin.add(width, height, length).subtract(BlockVector3.ONE));
        }
        byte[] blockId = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "Blocks", ByteArrayTag.class).getValue();
        byte[] blockData = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "Data", ByteArrayTag.class).getValue();
        byte[] addId = new byte[]{};
        short[] blocks = new short[blockId.length];
        if (schematic.containsKey("AddBlocks")) {
            addId = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "AddBlocks", ByteArrayTag.class).getValue();
        }
        for (int index = 0; index < blockId.length; ++index) {
            blocks[index] = index >> 1 >= addId.length ? (short)(blockId[index] & 0xFF) : ((index & 1) == 0 ? (short)(((addId[index >> 1] & 0xF) << 8) + (blockId[index] & 0xFF)) : (short)(((addId[index >> 1] & 0xF0) << 4) + (blockId[index] & 0xFF)));
        }
        Object tileEntities = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "TileEntities", ListTag.class).getValue();
        HashMap<BlockVector3, HashMap<String, Tag>> tileEntitiesMap = new HashMap<BlockVector3, HashMap<String, Tag>>();
        Iterator offsetZ = tileEntities.iterator();
        while (offsetZ.hasNext()) {
            Tag tag = (Tag)offsetZ.next();
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag t = (CompoundTag)tag;
            int x = 0;
            int y = 0;
            int z = 0;
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            for (Map.Entry entry : t.getValue().entrySet()) {
                switch ((String)entry.getKey()) {
                    case "x": {
                        if (!(entry.getValue() instanceof IntTag)) break;
                        x = ((IntTag)entry.getValue()).getValue();
                        break;
                    }
                    case "y": {
                        if (!(entry.getValue() instanceof IntTag)) break;
                        y = ((IntTag)entry.getValue()).getValue();
                        break;
                    }
                    case "z": {
                        if (!(entry.getValue() instanceof IntTag)) break;
                        z = ((IntTag)entry.getValue()).getValue();
                    }
                }
                values.put((String)entry.getKey(), (Tag)entry.getValue());
            }
            int index = y * width * length + z * width + x;
            BlockState block = LegacyMapper.getInstance().getBlockFromLegacy(blocks[index], blockData[index]);
            if (block != null) {
                for (NBTCompatibilityHandler handler : COMPATIBILITY_HANDLERS) {
                    if (!handler.isAffectedBlock(block)) continue;
                    handler.updateNBT(block, values);
                }
            }
            BlockVector3 vec = BlockVector3.at(x, y, z);
            tileEntitiesMap.put(vec, values);
        }
        BlockArrayClipboard clipboard = new BlockArrayClipboard(region);
        clipboard.setOrigin(origin);
        int failedBlockSets = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = y * width * length + z * width + x;
                    BlockVector3 pt = BlockVector3.at(x, y, z);
                    BlockState state = LegacyMapper.getInstance().getBlockFromLegacy(blocks[index], blockData[index]);
                    try {
                        if (state != null) {
                            if (tileEntitiesMap.containsKey(pt)) {
                                clipboard.setBlock(region.getMinimumPoint().add(pt), state.toBaseBlock(new CompoundTag((Map)tileEntitiesMap.get(pt))));
                                continue;
                            }
                            clipboard.setBlock(region.getMinimumPoint().add(pt), state);
                            continue;
                        }
                        log.warning("Unknown block when pasting schematic: " + blocks[index] + ":" + blockData[index] + ". Please report this issue.");
                        continue;
                    }
                    catch (WorldEditException e) {
                        switch (failedBlockSets) {
                            case 0: {
                                log.log(Level.WARNING, "Failed to set block on a Clipboard", e);
                                break;
                            }
                            case 1: {
                                log.log(Level.WARNING, "Failed to set block on a Clipboard (again) -- no more messages will be logged", e);
                                break;
                            }
                        }
                        ++failedBlockSets;
                    }
                }
            }
        }
        try {
            Object entityTags = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "Entities", ListTag.class).getValue();
            Iterator iterator = entityTags.iterator();
            while (iterator.hasNext()) {
                Tag tag = (Tag)iterator.next();
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag compound = (CompoundTag)tag;
                String id = this.convertEntityId(compound.getString("id"));
                Location location = NBTConversions.toLocation(clipboard, compound.getListTag("Pos"), compound.getListTag("Rotation"));
                if (id.isEmpty()) continue;
                EntityType entityType = EntityTypes.get(id.toLowerCase());
                if (entityType != null) {
                    BaseEntity state = new BaseEntity(entityType, compound);
                    clipboard.createEntity(location, state);
                    continue;
                }
                log.warning("Unknown entity when pasting schematic: " + id.toLowerCase());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return clipboard;
    }

    private String convertEntityId(String id) {
        switch (id) {
            case "xp_orb": {
                return "experience_orb";
            }
            case "xp_bottle": {
                return "experience_bottle";
            }
            case "eye_of_ender_signal": {
                return "eye_of_ender";
            }
            case "ender_crystal": {
                return "end_crystal";
            }
            case "fireworks_rocket": {
                return "firework_rocket";
            }
            case "commandblock_minecart": {
                return "command_block_minecart";
            }
            case "snowman": {
                return "snow_golem";
            }
            case "villager_golem": {
                return "iron_golem";
            }
            case "evocation_fangs": {
                return "evoker_fangs";
            }
            case "evocation_illager": {
                return "evoker";
            }
            case "vindication_illager": {
                return "vindicator";
            }
            case "illusion_illager": {
                return "illusioner";
            }
        }
        return id;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    static {
        COMPATIBILITY_HANDLERS.add(new SignCompatibilityHandler());
        log = Logger.getLogger(MCEditSchematicReader.class.getCanonicalName());
    }
}

