/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NamedTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.NBTSchematicReader;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.NBTCompatibilityHandler;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class SpongeSchematicReader
extends NBTSchematicReader {
    private static final List<NBTCompatibilityHandler> COMPATIBILITY_HANDLERS = new ArrayList<NBTCompatibilityHandler>();
    private static final Logger log = Logger.getLogger(SpongeSchematicReader.class.getCanonicalName());
    private final NBTInputStream inputStream;

    public SpongeSchematicReader(NBTInputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        this.inputStream = inputStream;
    }

    @Override
    public Clipboard read() throws IOException {
        NamedTag rootTag = this.inputStream.readNamedTag();
        if (!rootTag.getName().equals("Schematic")) {
            throw new IOException("Tag 'Schematic' does not exist or is not first");
        }
        CompoundTag schematicTag = (CompoundTag)rootTag.getTag();
        Object schematic = schematicTag.getValue();
        int version = SpongeSchematicReader.requireTag((Map<String, Tag>)schematic, "Version", IntTag.class).getValue();
        switch (version) {
            case 1: {
                return this.readVersion1((Map<String, Tag>)schematic);
            }
        }
        throw new IOException("This schematic version is currently not supported");
    }

    private Clipboard readVersion1(Map<String, Tag> schematic) throws IOException {
        CuboidRegion region;
        BlockVector3 origin;
        Object metadata = SpongeSchematicReader.requireTag(schematic, "Metadata", CompoundTag.class).getValue();
        short width = SpongeSchematicReader.requireTag(schematic, "Width", ShortTag.class).getValue();
        short height = SpongeSchematicReader.requireTag(schematic, "Height", ShortTag.class).getValue();
        short length = SpongeSchematicReader.requireTag(schematic, "Length", ShortTag.class).getValue();
        int[] offsetParts = SpongeSchematicReader.requireTag(schematic, "Offset", IntArrayTag.class).getValue();
        if (offsetParts.length != 3) {
            throw new IOException("Invalid offset specified in schematic.");
        }
        BlockVector3 min = BlockVector3.at(offsetParts[0], offsetParts[1], offsetParts[2]);
        if (metadata.containsKey("WEOffsetX")) {
            int offsetX = SpongeSchematicReader.requireTag((Map<String, Tag>)metadata, "WEOffsetX", IntTag.class).getValue();
            int offsetY = SpongeSchematicReader.requireTag((Map<String, Tag>)metadata, "WEOffsetY", IntTag.class).getValue();
            int offsetZ = SpongeSchematicReader.requireTag((Map<String, Tag>)metadata, "WEOffsetZ", IntTag.class).getValue();
            BlockVector3 offset = BlockVector3.at(offsetX, offsetY, offsetZ);
            origin = min.subtract(offset);
            region = new CuboidRegion(min, min.add(width, height, length).subtract(BlockVector3.ONE));
        } else {
            origin = min;
            region = new CuboidRegion(origin, origin.add(width, height, length).subtract(BlockVector3.ONE));
        }
        int paletteMax = SpongeSchematicReader.requireTag(schematic, "PaletteMax", IntTag.class).getValue();
        Object paletteObject = SpongeSchematicReader.requireTag(schematic, "Palette", CompoundTag.class).getValue();
        if (paletteObject.size() != paletteMax) {
            throw new IOException("Differing given palette size to actual size");
        }
        HashMap<Integer, BlockState> palette = new HashMap<Integer, BlockState>();
        ParserContext parserContext = new ParserContext();
        parserContext.setRestricted(false);
        parserContext.setTryLegacy(false);
        parserContext.setPreferringWildcard(false);
        for (String palettePart : paletteObject.keySet()) {
            BlockState state;
            int id = SpongeSchematicReader.requireTag((Map<String, Tag>)paletteObject, palettePart, IntTag.class).getValue();
            try {
                state = ((BlockStateHolder)WorldEdit.getInstance().getBlockFactory().parseFromInput(palettePart, parserContext)).toImmutableState();
            }
            catch (InputParseException e) {
                throw new IOException("Invalid BlockState in schematic: " + palettePart + ". Are you missing a mod of using a schematic made in a newer version of Minecraft?");
            }
            palette.put(id, state);
        }
        byte[] blocks = SpongeSchematicReader.requireTag(schematic, "BlockData", ByteArrayTag.class).getValue();
        HashMap<BlockVector3, Map> tileEntitiesMap = new HashMap<BlockVector3, Map>();
        try {
            List tileEntityTags = SpongeSchematicReader.requireTag(schematic, "TileEntities", ListTag.class).getValue().stream().map(tag -> (CompoundTag)tag).map(CompoundTag::getValue).collect(Collectors.toList());
            for (Map tileEntity : tileEntityTags) {
                int[] pos = SpongeSchematicReader.requireTag(tileEntity, "Pos", IntArrayTag.class).getValue();
                tileEntitiesMap.put(BlockVector3.at(pos[0], pos[1], pos[2]), tileEntity);
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to load Tile Entities: " + e.getMessage());
        }
        BlockArrayClipboard clipboard = new BlockArrayClipboard(region);
        clipboard.setOrigin(origin);
        int index = 0;
        int i = 0;
        int value = 0;
        int varintLength = 0;
        while (i < blocks.length) {
            value = 0;
            varintLength = 0;
            while (true) {
                value |= (blocks[i] & 0x7F) << varintLength++ * 7;
                if (varintLength > 5) {
                    throw new RuntimeException("VarInt too big (probably corrupted data)");
                }
                if ((blocks[i] & 0x80) != 128) {
                    ++i;
                    break;
                }
                ++i;
            }
            int y = index / (width * length);
            int z = index % (width * length) / width;
            int x = index % (width * length) % width;
            BlockState state = (BlockState)palette.get(value);
            BlockVector3 pt = BlockVector3.at(x, y, z);
            try {
                if (tileEntitiesMap.containsKey(pt)) {
                    HashMap values = Maps.newHashMap((Map)((Map)tileEntitiesMap.get(pt)));
                    for (NBTCompatibilityHandler handler : COMPATIBILITY_HANDLERS) {
                        if (!handler.isAffectedBlock(state)) continue;
                        handler.updateNBT(state, values);
                    }
                    values.put("x", new IntTag(pt.getBlockX()));
                    values.put("y", new IntTag(pt.getBlockY()));
                    values.put("z", new IntTag(pt.getBlockZ()));
                    values.put("id", values.get("Id"));
                    values.remove("Id");
                    values.remove("Pos");
                    clipboard.setBlock(clipboard.getMinimumPoint().add(pt), state.toBaseBlock(new CompoundTag(values)));
                } else {
                    clipboard.setBlock(clipboard.getMinimumPoint().add(pt), state);
                }
            }
            catch (WorldEditException e) {
                throw new IOException("Failed to load a block in the schematic");
            }
            ++index;
        }
        return clipboard;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

