/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.transform;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.registry.state.BooleanProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class BlockTransformExtent
extends AbstractDelegateExtent {
    private final Transform transform;
    private static final Set<String> directionNames = Sets.newHashSet((Object[])new String[]{"north", "south", "east", "west"});

    public BlockTransformExtent(Extent extent, Transform transform) {
        super(extent);
        Preconditions.checkNotNull((Object)transform);
        this.transform = transform;
    }

    public Transform getTransform() {
        return this.transform;
    }

    private <T extends BlockStateHolder> T transformBlock(T block, boolean reverse) {
        return BlockTransformExtent.transform(block, reverse ? this.transform.inverse() : this.transform);
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        return this.transformBlock(super.getBlock(position), false);
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        return this.transformBlock(super.getFullBlock(position), false);
    }

    @Override
    public boolean setBlock(BlockVector3 location, BlockStateHolder block) throws WorldEditException {
        return super.setBlock(location, this.transformBlock(block, true));
    }

    public static <T extends BlockStateHolder> T transform(T block, Transform transform) {
        return BlockTransformExtent.transform(block, transform, block);
    }

    private static <T extends BlockStateHolder> T transform(T block, Transform transform, T changedBlock) {
        Preconditions.checkNotNull(block);
        Preconditions.checkNotNull((Object)transform);
        List<? extends Property> properties = block.getBlockType().getProperties();
        for (Property property2 : properties) {
            Object newValue;
            Direction value;
            if (property2 instanceof DirectionalProperty) {
                value = (Direction)((Object)block.getState(property2));
                if (value == null || (newValue = BlockTransformExtent.getNewStateValue(property2.getValues(), transform, value.toVector())) == null) continue;
                changedBlock = changedBlock.with(property2, (Direction)Direction.findClosest((Vector3)newValue, Direction.Flag.ALL));
                continue;
            }
            if (!(property2 instanceof EnumProperty) || !property2.getName().equals("axis")) continue;
            value = null;
            switch ((String)block.getState(property2)) {
                case "x": {
                    value = Direction.EAST;
                    break;
                }
                case "y": {
                    value = Direction.UP;
                    break;
                }
                case "z": {
                    value = Direction.NORTH;
                }
            }
            if (value == null || (newValue = BlockTransformExtent.getNewStateValue(Direction.valuesOf(Direction.Flag.UPRIGHT | Direction.Flag.CARDINAL), transform, value.toVector())) == null) continue;
            String axis = null;
            Direction newDir = Direction.findClosest((Vector3)newValue, Direction.Flag.UPRIGHT | Direction.Flag.CARDINAL);
            if (newDir == Direction.NORTH || newDir == Direction.SOUTH) {
                axis = "z";
            } else if (newDir == Direction.EAST || newDir == Direction.WEST) {
                axis = "x";
            } else if (newDir == Direction.UP || newDir == Direction.DOWN) {
                axis = "y";
            }
            if (axis == null) continue;
            changedBlock = changedBlock.with(property2, (String)axis);
        }
        List directionalProperties = properties.stream().filter(prop -> prop instanceof BooleanProperty).filter(prop -> directionNames.contains(prop.getName())).filter(property -> (Boolean)block.getState(property)).map(Property::getName).map(String::toUpperCase).map(Direction::valueOf).map(dir -> Direction.findClosest(transform.apply(dir.toVector()), Direction.Flag.CARDINAL)).filter(Objects::nonNull).map(Enum::name).map(String::toLowerCase).collect(Collectors.toList());
        if (directionalProperties.size() > 0) {
            for (String directionName : directionNames) {
                changedBlock = changedBlock.with(block.getBlockType().getProperty(directionName), directionalProperties.contains(directionName));
            }
        }
        return changedBlock;
    }

    @Nullable
    private static Vector3 getNewStateValue(List<Direction> allowedStates, Transform transform, Vector3 oldDirection) {
        Vector3 newDirection = transform.apply(oldDirection).subtract(transform.apply(Vector3.ZERO)).normalize();
        Vector3 newValue = null;
        double closest = -2.0;
        boolean found = false;
        for (Direction v : allowedStates) {
            double dot = v.toVector().normalize().dot(newDirection);
            if (!(dot >= closest)) continue;
            closest = dot;
            newValue = v.toVector();
            found = true;
        }
        if (found) {
            return newValue;
        }
        return null;
    }
}

