/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.block;

import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.Countable;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlockDistributionCounter
implements RegionFunction {
    private Extent extent;
    private boolean fuzzy;
    private List<Countable<BlockStateHolder>> distribution = new ArrayList<Countable<BlockStateHolder>>();
    private Map<BlockStateHolder, Countable<BlockStateHolder>> map = new HashMap<BlockStateHolder, Countable<BlockStateHolder>>();

    public BlockDistributionCounter(Extent extent, boolean fuzzy) {
        this.extent = extent;
        this.fuzzy = fuzzy;
    }

    @Override
    public boolean apply(BlockVector3 position) throws WorldEditException {
        BlockState blk = this.extent.getBlock(position);
        if (this.fuzzy) {
            blk = blk.toFuzzy();
        }
        if (this.map.containsKey(blk)) {
            this.map.get(blk).increment();
        } else {
            Countable<BlockState> c = new Countable<BlockState>(blk, 1);
            this.map.put(blk, c);
            this.distribution.add(c);
        }
        return true;
    }

    public List<Countable<BlockStateHolder>> getDistribution() {
        Collections.sort(this.distribution);
        Collections.reverse(this.distribution);
        return this.distribution;
    }
}

