/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.pattern;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class ClipboardPattern
extends AbstractPattern {
    private final Clipboard clipboard;
    private final BlockVector3 size;

    public ClipboardPattern(Clipboard clipboard) {
        Preconditions.checkNotNull((Object)clipboard);
        this.clipboard = clipboard;
        this.size = clipboard.getMaximumPoint().subtract(clipboard.getMinimumPoint()).add(1, 1, 1);
    }

    @Override
    public BlockStateHolder apply(BlockVector3 position) {
        int xp = Math.abs(position.getBlockX()) % this.size.getBlockX();
        int yp = Math.abs(position.getBlockY()) % this.size.getBlockY();
        int zp = Math.abs(position.getBlockZ()) % this.size.getBlockZ();
        return this.clipboard.getFullBlock(this.clipboard.getMinimumPoint().add(xp, yp, zp));
    }
}

