/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.pattern;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class RepeatingExtentPattern
extends AbstractPattern {
    private Extent extent;
    private BlockVector3 offset;

    public RepeatingExtentPattern(Extent extent, BlockVector3 offset) {
        this.setExtent(extent);
        this.setOffset(offset);
    }

    public Extent getExtent() {
        return this.extent;
    }

    public void setExtent(Extent extent) {
        Preconditions.checkNotNull((Object)extent);
        this.extent = extent;
    }

    public BlockVector3 getOffset() {
        return this.offset;
    }

    public void setOffset(BlockVector3 offset) {
        Preconditions.checkNotNull((Object)offset);
        this.offset = offset;
    }

    @Override
    public BlockStateHolder apply(BlockVector3 position) {
        BlockVector3 base = position.add(this.offset);
        BlockVector3 size = this.extent.getMaximumPoint().subtract(this.extent.getMinimumPoint()).add(1, 1, 1);
        int x = base.getBlockX() % size.getBlockX();
        int y = base.getBlockY() % size.getBlockY();
        int z = base.getBlockZ() % size.getBlockZ();
        return this.extent.getFullBlock(BlockVector3.at(x, y, z));
    }
}

