/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.expression;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.internal.expression.lexer.Lexer;
import com.sk89q.worldedit.internal.expression.lexer.tokens.Token;
import com.sk89q.worldedit.internal.expression.parser.Parser;
import com.sk89q.worldedit.internal.expression.runtime.Constant;
import com.sk89q.worldedit.internal.expression.runtime.EvaluationException;
import com.sk89q.worldedit.internal.expression.runtime.ExpressionEnvironment;
import com.sk89q.worldedit.internal.expression.runtime.Functions;
import com.sk89q.worldedit.internal.expression.runtime.RValue;
import com.sk89q.worldedit.internal.expression.runtime.ReturnException;
import com.sk89q.worldedit.internal.expression.runtime.Variable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Expression {
    private static final ThreadLocal<Stack<Expression>> instance = new ThreadLocal();
    private static final ExecutorService evalThread = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("worldedit-expression-eval-%d").build());
    private final Map<String, RValue> variables = new HashMap<String, RValue>();
    private final String[] variableNames;
    private RValue root;
    private final Functions functions = new Functions();
    private ExpressionEnvironment environment;

    public static Expression compile(String expression, String ... variableNames) throws ExpressionException {
        return new Expression(expression, variableNames);
    }

    private Expression(String expression, String ... variableNames) throws ExpressionException {
        this(Lexer.tokenize(expression), variableNames);
    }

    private Expression(List<Token> tokens, String ... variableNames) throws ExpressionException {
        this.variableNames = variableNames;
        this.variables.put("e", new Constant(-1, Math.E));
        this.variables.put("pi", new Constant(-1, Math.PI));
        this.variables.put("true", new Constant(-1, 1.0));
        this.variables.put("false", new Constant(-1, 0.0));
        for (String variableName : variableNames) {
            if (this.variables.containsKey(variableName)) {
                throw new ExpressionException(-1, "Tried to overwrite identifier '" + variableName + "'");
            }
            this.variables.put(variableName, new Variable(0.0));
        }
        this.root = Parser.parse(tokens, this);
    }

    public double evaluate(double ... values) throws EvaluationException {
        for (int i = 0; i < values.length; ++i) {
            String variableName = this.variableNames[i];
            RValue invokable = this.variables.get(variableName);
            if (!(invokable instanceof Variable)) {
                throw new EvaluationException(invokable.getPosition(), "Tried to assign constant " + variableName + ".");
            }
            ((Variable)invokable).value = values[i];
        }
        Future<Double> result = evalThread.submit(new Callable<Double>(){

            @Override
            public Double call() throws Exception {
                Expression.this.pushInstance();
                try {
                    Double d = Expression.this.root.getValue();
                    return d;
                }
                finally {
                    Expression.this.popInstance();
                }
            }
        });
        try {
            return result.get(WorldEdit.getInstance().getConfiguration().calculationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ReturnException) {
                return ((ReturnException)cause).getValue();
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw new EvaluationException(-1, "Calculations exceeded time limit.");
        }
    }

    public void optimize() throws EvaluationException {
        this.root = this.root.optimize();
    }

    public String toString() {
        return this.root.toString();
    }

    public RValue getVariable(String name, boolean create) {
        RValue variable = this.variables.get(name);
        if (variable == null && create) {
            variable = new Variable(0.0);
            this.variables.put(name, variable);
        }
        return variable;
    }

    public static Expression getInstance() {
        return instance.get().peek();
    }

    private void pushInstance() {
        Stack<Expression> threadLocalExprStack = instance.get();
        if (threadLocalExprStack == null) {
            threadLocalExprStack = new Stack();
            instance.set(threadLocalExprStack);
        }
        threadLocalExprStack.push(this);
    }

    private void popInstance() {
        Stack<Expression> threadLocalExprStack = instance.get();
        threadLocalExprStack.pop();
        if (threadLocalExprStack.isEmpty()) {
            instance.set(null);
        }
    }

    public Functions getFunctions() {
        return this.functions;
    }

    public ExpressionEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(ExpressionEnvironment environment) {
        this.environment = environment;
    }
}

