/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions.shape;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.biome.BaseBiome;

public abstract class ArbitraryBiomeShape {
    private final FlatRegion extent;
    private int cacheOffsetX;
    private int cacheOffsetZ;
    private int cacheSizeX;
    private int cacheSizeZ;
    private final BaseBiome[] cache;
    private static final BaseBiome OUTSIDE = new BaseBiome(0){

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }
    };

    public ArbitraryBiomeShape(Region extent) {
        this.extent = extent instanceof FlatRegion ? (FlatRegion)extent : new CuboidRegion(extent.getWorld(), extent.getMinimumPoint(), extent.getMaximumPoint());
        BlockVector2 min = extent.getMinimumPoint().toBlockVector2();
        BlockVector2 max = extent.getMaximumPoint().toBlockVector2();
        this.cacheOffsetX = min.getBlockX() - 1;
        this.cacheOffsetZ = min.getBlockZ() - 1;
        this.cacheSizeX = max.getX() - this.cacheOffsetX + 2;
        this.cacheSizeZ = max.getZ() - this.cacheOffsetZ + 2;
        this.cache = new BaseBiome[this.cacheSizeX * this.cacheSizeZ];
    }

    protected Iterable<BlockVector2> getExtent() {
        return this.extent.asFlatRegion();
    }

    protected abstract BaseBiome getBiome(int var1, int var2, BaseBiome var3);

    private BaseBiome getBiomeCached(int x, int z, BaseBiome baseBiome) {
        int index = z - this.cacheOffsetZ + (x - this.cacheOffsetX) * this.cacheSizeZ;
        BaseBiome cacheEntry = this.cache[index];
        if (cacheEntry == null) {
            BaseBiome material = this.getBiome(x, z, baseBiome);
            if (material == null) {
                this.cache[index] = OUTSIDE;
                return null;
            }
            this.cache[index] = material;
            return material;
        }
        if (cacheEntry == OUTSIDE) {
            return null;
        }
        return cacheEntry;
    }

    private boolean isInsideCached(int x, int z, BaseBiome baseBiome) {
        int index = z - this.cacheOffsetZ + (x - this.cacheOffsetX) * this.cacheSizeZ;
        BaseBiome cacheEntry = this.cache[index];
        if (cacheEntry == null) {
            return this.getBiomeCached(x, z, baseBiome) != null;
        }
        return cacheEntry != OUTSIDE;
    }

    public int generate(EditSession editSession, BaseBiome baseBiome, boolean hollow) {
        int affected = 0;
        for (BlockVector2 position : this.getExtent()) {
            BaseBiome material;
            int x = position.getBlockX();
            int z = position.getBlockZ();
            if (!hollow) {
                material = this.getBiome(x, z, baseBiome);
                if (material == null || material == OUTSIDE) continue;
                editSession.getWorld().setBiome(position, material);
                ++affected;
                continue;
            }
            material = this.getBiomeCached(x, z, baseBiome);
            if (material == null) continue;
            boolean draw = false;
            if (!this.isInsideCached(x + 1, z, baseBiome)) {
                draw = true;
            } else if (!this.isInsideCached(x - 1, z, baseBiome)) {
                draw = true;
            } else if (!this.isInsideCached(x, z + 1, baseBiome)) {
                draw = true;
            } else if (!this.isInsideCached(x, z - 1, baseBiome)) {
                draw = true;
            }
            if (!draw) continue;
            editSession.getWorld().setBiome(position, material);
            ++affected;
        }
        return affected;
    }
}

