/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util;

import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;

public class TargetBlock {
    private World world;
    private int maxDistance;
    private double checkDistance;
    private double curDistance;
    private BlockVector3 targetPos = BlockVector3.ZERO;
    private Vector3 targetPosDouble = Vector3.ZERO;
    private BlockVector3 prevPos = BlockVector3.ZERO;
    private Vector3 offset = Vector3.ZERO;

    public TargetBlock(Player player) {
        this.world = player.getWorld();
        this.setValues(player.getLocation().toVector(), player.getLocation().getYaw(), player.getLocation().getPitch(), 300, 1.65, 0.2);
    }

    public TargetBlock(Player player, int maxDistance, double checkDistance) {
        this.world = player.getWorld();
        this.setValues(player.getLocation().toVector(), player.getLocation().getYaw(), player.getLocation().getPitch(), maxDistance, 1.65, checkDistance);
    }

    private void setValues(Vector3 loc, double xRotation, double yRotation, int maxDistance, double viewHeight, double checkDistance) {
        this.maxDistance = maxDistance;
        this.checkDistance = checkDistance;
        this.curDistance = 0.0;
        xRotation = (xRotation + 90.0) % 360.0;
        double h = checkDistance * Math.cos(Math.toRadians(yRotation *= -1.0));
        this.offset = Vector3.at(h * Math.cos(Math.toRadians(xRotation)), checkDistance * Math.sin(Math.toRadians(yRotation)), h * Math.sin(Math.toRadians(xRotation)));
        this.targetPosDouble = loc.add(0.0, viewHeight, 0.0);
        this.prevPos = this.targetPos = this.targetPosDouble.toBlockPoint();
    }

    public Location getAnyTargetBlock() {
        boolean searchForLastBlock = true;
        Location lastBlock = null;
        while (this.getNextBlock() != null && this.world.getBlock(this.targetPos).getBlockType().getMaterial().isAir()) {
            if (!searchForLastBlock || (lastBlock = this.getCurrentBlock()).getBlockY() > 0 && lastBlock.getBlockY() < this.world.getMaxY()) continue;
            searchForLastBlock = false;
        }
        Location currentBlock = this.getCurrentBlock();
        return currentBlock != null ? currentBlock : lastBlock;
    }

    public Location getTargetBlock() {
        while (this.getNextBlock() != null && this.world.getBlock(this.targetPos).getBlockType().getMaterial().isAir()) {
        }
        return this.getCurrentBlock();
    }

    public Location getSolidTargetBlock() {
        while (this.getNextBlock() != null && !this.world.getBlock(this.targetPos).getBlockType().getMaterial().isMovementBlocker()) {
        }
        return this.getCurrentBlock();
    }

    public Location getNextBlock() {
        this.prevPos = this.targetPos;
        do {
            this.curDistance += this.checkDistance;
            this.targetPosDouble = this.offset.add(this.targetPosDouble.getX(), this.targetPosDouble.getY(), this.targetPosDouble.getZ());
            this.targetPos = this.targetPosDouble.toBlockPoint();
        } while (this.curDistance <= (double)this.maxDistance && this.targetPos.getBlockX() == this.prevPos.getBlockX() && this.targetPos.getBlockY() == this.prevPos.getBlockY() && this.targetPos.getBlockZ() == this.prevPos.getBlockZ());
        if (this.curDistance > (double)this.maxDistance) {
            return null;
        }
        return new Location(this.world, this.targetPos.toVector3());
    }

    public Location getCurrentBlock() {
        if (this.curDistance > (double)this.maxDistance) {
            return null;
        }
        return new Location(this.world, this.targetPos.toVector3());
    }

    public Location getPreviousBlock() {
        return new Location(this.world, this.prevPos.toVector3());
    }

    public Location getAnyTargetBlockFace() {
        this.getAnyTargetBlock();
        return this.getCurrentBlock().setDirection(this.getCurrentBlock().toVector().subtract(this.getPreviousBlock().toVector()));
    }

    public Location getTargetBlockFace() {
        this.getAnyTargetBlock();
        return this.getCurrentBlock().setDirection(this.getCurrentBlock().toVector().subtract(this.getPreviousBlock().toVector()));
    }
}

