/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.collection;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.LocatedBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class LocatedBlockList
implements Iterable<LocatedBlock> {
    private final List<LocatedBlock> list;

    public LocatedBlockList() {
        this.list = new ArrayList<LocatedBlock>();
    }

    public LocatedBlockList(Collection<? extends LocatedBlock> collection) {
        this.list = new ArrayList<LocatedBlock>(collection);
    }

    public void add(LocatedBlock setBlockCall) {
        Preconditions.checkNotNull((Object)setBlockCall);
        this.list.add(setBlockCall);
    }

    public void add(BlockVector3 location, BlockStateHolder block) {
        this.add(new LocatedBlock(location, block));
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }

    @Override
    public Iterator<LocatedBlock> iterator() {
        return this.list.iterator();
    }

    public Iterator<LocatedBlock> reverseIterator() {
        return new Iterator<LocatedBlock>(){
            private final ListIterator<LocatedBlock> backingIterator;
            {
                this.backingIterator = LocatedBlockList.this.list.listIterator(LocatedBlockList.this.list.size());
            }

            @Override
            public boolean hasNext() {
                return this.backingIterator.hasPrevious();
            }

            @Override
            public LocatedBlock next() {
                return this.backingIterator.previous();
            }
        };
    }
}

