/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.paste;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.sk89q.worldedit.command.util.AsyncCommandHelper;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.command.parametric.ExceptionConverter;
import com.sk89q.worldedit.util.paste.EngineHubPaste;
import com.sk89q.worldedit.util.task.Supervisor;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActorCallbackPaste {
    private static final Logger LOGGER = Logger.getLogger(ActorCallbackPaste.class.getSimpleName());

    private ActorCallbackPaste() {
    }

    public static void pastebin(Supervisor supervisor, final Actor sender, String content, final String successMessage, ExceptionConverter exceptionConverter) {
        ListenableFuture<URL> future = new EngineHubPaste().paste(content);
        AsyncCommandHelper.wrap(future, supervisor, sender, exceptionConverter).registerWithSupervisor("Submitting content to a pastebin service...").sendMessageAfterDelay("(Please wait... sending output to pastebin...)");
        Futures.addCallback(future, (FutureCallback)new FutureCallback<URL>(){

            public void onSuccess(URL url) {
                sender.print(String.format(successMessage, url));
            }

            public void onFailure(Throwable throwable) {
                LOGGER.log(Level.WARNING, "Failed to submit pastebin", throwable);
                sender.printError("Failed to submit to a pastebin. Please see console for the error.");
            }
        });
    }
}

