/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.paste;

import com.google.common.util.concurrent.ListenableFuture;
import com.sk89q.worldedit.util.net.HttpRequest;
import com.sk89q.worldedit.util.paste.Paster;
import com.sk89q.worldedit.util.paste.Pasters;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONValue;

public class EngineHubPaste
implements Paster {
    private static final Pattern URL_PATTERN = Pattern.compile("https?://.+$");

    @Override
    public ListenableFuture<URL> paste(String content) {
        return Pasters.getExecutor().submit((Callable)new PasteTask(content));
    }

    private final class PasteTask
    implements Callable<URL> {
        private final String content;

        private PasteTask(String content) {
            this.content = content;
        }

        @Override
        public URL call() throws IOException, InterruptedException {
            HttpRequest.Form form = HttpRequest.Form.create();
            form.add("content", this.content);
            form.add("from", "worldguard");
            URL url = HttpRequest.url("http://paste.enginehub.org/paste");
            String result = HttpRequest.post(url).bodyForm(form).execute().expectResponseCode(200).returnContent().asString("UTF-8").trim();
            Object object = JSONValue.parse((String)result);
            if (object instanceof Map) {
                String urlString = String.valueOf(((Map)object).get("url"));
                Matcher m = URL_PATTERN.matcher(urlString);
                if (m.matches()) {
                    return new URL(urlString);
                }
            }
            throw new IOException("Failed to save paste; instead, got: " + result);
        }
    }
}

