/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.paste;

import com.google.common.util.concurrent.ListenableFuture;
import com.sk89q.worldedit.util.net.HttpRequest;
import com.sk89q.worldedit.util.paste.Paster;
import com.sk89q.worldedit.util.paste.Pasters;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Pastebin
implements Paster {
    private static final Pattern URL_PATTERN = Pattern.compile("https?://pastebin.com/([^/]+)$");
    private boolean mungingLinks = true;

    public boolean isMungingLinks() {
        return this.mungingLinks;
    }

    public void setMungingLinks(boolean mungingLinks) {
        this.mungingLinks = mungingLinks;
    }

    @Override
    public ListenableFuture<URL> paste(String content) {
        if (this.mungingLinks) {
            content = content.replaceAll("http://", "http_//");
        }
        return Pasters.getExecutor().submit((Callable)new PasteTask(content));
    }

    private final class PasteTask
    implements Callable<URL> {
        private final String content;

        private PasteTask(String content) {
            this.content = content;
        }

        @Override
        public URL call() throws IOException, InterruptedException {
            HttpRequest.Form form = HttpRequest.Form.create();
            form.add("api_option", "paste");
            form.add("api_dev_key", "4867eae74c6990dbdef07c543cf8f805");
            form.add("api_paste_code", this.content);
            form.add("api_paste_private", "0");
            form.add("api_paste_name", "");
            form.add("api_paste_expire_date", "1W");
            form.add("api_paste_format", "text");
            form.add("api_user_key", "");
            URL url = HttpRequest.url("http://pastebin.com/api/api_post.php");
            String result = HttpRequest.post(url).bodyForm(form).execute().expectResponseCode(200).returnContent().asString("UTF-8").trim();
            Matcher m = URL_PATTERN.matcher(result);
            if (m.matches()) {
                return new URL("http://pastebin.com/raw.php?i=" + m.group(1));
            }
            if (result.matches("^https?://.+")) {
                return new URL(result);
            }
            throw new IOException("Failed to save paste; instead, got: " + result);
        }
    }
}

