/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class BaseBlock
implements BlockStateHolder<BaseBlock>,
TileEntityBlock {
    private BlockState blockState;
    @Nullable
    private CompoundTag nbtData;

    protected BaseBlock(BlockState blockState) {
        this.blockState = blockState;
    }

    protected BaseBlock(BlockState state, CompoundTag nbtData) {
        Preconditions.checkNotNull((Object)nbtData);
        this.blockState = state;
        this.nbtData = nbtData;
    }

    @Override
    public Map<Property<?>, Object> getStates() {
        return this.blockState.getStates();
    }

    @Override
    public BlockType getBlockType() {
        return this.blockState.getBlockType();
    }

    @Override
    public <V> BaseBlock with(Property<V> property, V value) {
        return ((BlockState)this.blockState.with((Property)property, (Object)value)).toBaseBlock(this.getNbtData());
    }

    @Override
    public <V> V getState(Property<V> property) {
        return this.blockState.getState(property);
    }

    @Override
    public boolean hasNbtData() {
        return this.getNbtData() != null;
    }

    @Override
    public String getNbtId() {
        CompoundTag nbtData = this.getNbtData();
        if (nbtData == null) {
            return "";
        }
        Tag idTag = (Tag)nbtData.getValue().get("id");
        if (idTag instanceof StringTag) {
            return ((StringTag)idTag).getValue();
        }
        return "";
    }

    @Override
    @Nullable
    public CompoundTag getNbtData() {
        return this.nbtData;
    }

    @Override
    public void setNbtData(@Nullable CompoundTag nbtData) {
        throw new UnsupportedOperationException("This class is immutable.");
    }

    public boolean equals(Object o) {
        if (!(o instanceof BaseBlock)) {
            if (!this.hasNbtData() && o instanceof BlockStateHolder) {
                return Objects.equals(this.toImmutableState(), ((BlockStateHolder)o).toImmutableState());
            }
            return false;
        }
        BaseBlock otherBlock = (BaseBlock)o;
        return this.toImmutableState().equalsFuzzy(otherBlock.toImmutableState()) && Objects.equals(this.getNbtData(), otherBlock.getNbtData());
    }

    @Override
    public boolean equalsFuzzy(BlockStateHolder o) {
        return this.toImmutableState().equalsFuzzy(o);
    }

    @Override
    public BlockState toImmutableState() {
        return this.blockState;
    }

    @Override
    public BaseBlock toBaseBlock() {
        return this;
    }

    @Override
    public BaseBlock toBaseBlock(CompoundTag compoundTag) {
        if (compoundTag == null) {
            return this.blockState.toBaseBlock();
        }
        if (compoundTag == this.nbtData) {
            return this;
        }
        return new BaseBlock(this.blockState, compoundTag);
    }

    public int hashCode() {
        int ret = this.toImmutableState().hashCode() << 3;
        if (this.hasNbtData()) {
            ret += this.getNbtData().hashCode();
        }
        return ret;
    }

    public String toString() {
        return this.blockState.getAsString();
    }
}

