/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.item;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.registry.NamespacedRegistry;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import javax.annotation.Nullable;

public class ItemType {
    public static final NamespacedRegistry<ItemType> REGISTRY = new NamespacedRegistry("item type");
    private String id;

    public ItemType(String id) {
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        String name = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getItemRegistry().getName(this);
        if (name == null) {
            return this.getId();
        }
        return name;
    }

    public boolean hasBlockType() {
        return this.getBlockType() != null;
    }

    @Nullable
    public BlockType getBlockType() {
        return BlockTypes.get(this.id);
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ItemType && this.id.equals(((ItemType)obj).id);
    }
}

