/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.registry;

import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.gson.VectorAdapter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class BundledItemData {
    private static final Logger log = Logger.getLogger(BundledItemData.class.getCanonicalName());
    private static BundledItemData INSTANCE;
    private final Map<String, ItemEntry> idMap = new HashMap<String, ItemEntry>();

    private BundledItemData() {
        try {
            this.loadFromResource();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Failed to load the built-in item registry", e);
        }
    }

    private void loadFromResource() throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Vector3.class, (Object)new VectorAdapter());
        Gson gson = gsonBuilder.create();
        URL url = BundledItemData.class.getResource("items.json");
        if (url == null) {
            throw new IOException("Could not find items.json");
        }
        String data = Resources.toString((URL)url, (Charset)Charset.defaultCharset());
        List entries = (List)gson.fromJson(data, new TypeToken<List<ItemEntry>>(){}.getType());
        for (ItemEntry entry : entries) {
            this.idMap.put(entry.id, entry);
        }
    }

    @Nullable
    public ItemEntry findById(String id) {
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        return this.idMap.get(id);
    }

    public static BundledItemData getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BundledItemData();
        }
        return INSTANCE;
    }

    public static class ItemEntry {
        private String id;
        private String unlocalizedName;
        public String localizedName;
        private int maxDamage;
        private int maxStackSize;
    }
}

