/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.registry;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.gson.VectorAdapter;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class LegacyMapper {
    private static final Logger log = Logger.getLogger(LegacyMapper.class.getCanonicalName());
    private static LegacyMapper INSTANCE;
    private Multimap<String, BlockState> stringToBlockMap = HashMultimap.create();
    private Multimap<BlockState, String> blockToStringMap = HashMultimap.create();
    private Multimap<String, ItemType> stringToItemMap = HashMultimap.create();
    private Multimap<ItemType, String> itemToStringMap = HashMultimap.create();

    private LegacyMapper() {
        try {
            this.loadFromResource();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Failed to load the built-in legacy id registry", e);
        }
    }

    private void loadFromResource() throws IOException {
        String id;
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Vector3.class, (Object)new VectorAdapter());
        Gson gson = gsonBuilder.disableHtmlEscaping().create();
        URL url = LegacyMapper.class.getResource("legacy.json");
        if (url == null) {
            throw new IOException("Could not find legacy.json");
        }
        String data = Resources.toString((URL)url, (Charset)Charset.defaultCharset());
        LegacyDataFile dataFile = (LegacyDataFile)gson.fromJson(data, new TypeToken<LegacyDataFile>(){}.getType());
        ParserContext parserContext = new ParserContext();
        parserContext.setPreferringWildcard(false);
        parserContext.setRestricted(false);
        parserContext.setTryLegacy(false);
        for (Map.Entry blockEntry : dataFile.blocks.entrySet()) {
            try {
                id = (String)blockEntry.getKey();
                BlockState state = ((BlockStateHolder)WorldEdit.getInstance().getBlockFactory().parseFromInput((String)blockEntry.getValue(), parserContext)).toImmutableState();
                this.blockToStringMap.put((Object)state, (Object)id);
                this.stringToBlockMap.put((Object)id, (Object)state);
            }
            catch (Exception e) {
                log.warning("Unknown block: " + (String)blockEntry.getValue());
            }
        }
        for (Map.Entry itemEntry : dataFile.items.entrySet()) {
            try {
                id = (String)itemEntry.getKey();
                ItemType type = ItemTypes.get((String)itemEntry.getValue());
                this.itemToStringMap.put((Object)type, (Object)id);
                this.stringToItemMap.put((Object)id, (Object)type);
            }
            catch (Exception e) {
                log.warning("Unknown item: " + (String)itemEntry.getValue());
            }
        }
    }

    @Nullable
    public ItemType getItemFromLegacy(int legacyId) {
        return this.getItemFromLegacy(legacyId, 0);
    }

    @Nullable
    public ItemType getItemFromLegacy(int legacyId, int data) {
        return this.stringToItemMap.get((Object)(legacyId + ":" + data)).stream().findFirst().orElse(null);
    }

    @Nullable
    public int[] getLegacyFromItem(ItemType itemType) {
        if (!this.itemToStringMap.containsKey((Object)itemType)) {
            return null;
        }
        String value = (String)this.itemToStringMap.get((Object)itemType).stream().findFirst().get();
        return Arrays.stream(value.split(":")).mapToInt(Integer::parseInt).toArray();
    }

    @Nullable
    public BlockState getBlockFromLegacy(int legacyId) {
        return this.getBlockFromLegacy(legacyId, 0);
    }

    @Nullable
    public BlockState getBlockFromLegacy(int legacyId, int data) {
        return this.stringToBlockMap.get((Object)(legacyId + ":" + data)).stream().findFirst().orElse(null);
    }

    @Nullable
    public int[] getLegacyFromBlock(BlockState blockState) {
        if (!this.blockToStringMap.containsKey((Object)blockState)) {
            return null;
        }
        String value = (String)this.blockToStringMap.get((Object)blockState).stream().findFirst().get();
        return Arrays.stream(value.split(":")).mapToInt(Integer::parseInt).toArray();
    }

    public static LegacyMapper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LegacyMapper();
        }
        return INSTANCE;
    }

    private static class LegacyDataFile {
        private Map<String, String> blocks;
        private Map<String, String> items;

        private LegacyDataFile() {
        }
    }
}

