/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.storage;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.chunk.AnvilChunk;
import com.sk89q.worldedit.world.chunk.AnvilChunk13;
import com.sk89q.worldedit.world.chunk.Chunk;
import com.sk89q.worldedit.world.chunk.OldChunk;
import com.sk89q.worldedit.world.storage.ChunkStoreException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;

public abstract class ChunkStore
implements Closeable {
    public static final int DATA_VERSION_MC_1_13 = 1519;
    public static final int CHUNK_SHIFTS = 4;

    public static BlockVector2 toChunk(BlockVector3 position) {
        return BlockVector2.at(position.getX() >> 4, position.getZ() >> 4);
    }

    public abstract CompoundTag getChunkTag(BlockVector2 var1, World var2) throws DataException, IOException;

    public Chunk getChunk(BlockVector2 position, World world) throws DataException, IOException {
        CompoundTag rootTag = this.getChunkTag(position, world);
        Object children = rootTag.getValue();
        CompoundTag tag = null;
        for (Map.Entry entry : children.entrySet()) {
            if (!((String)entry.getKey()).equals("Level")) continue;
            if (entry.getValue() instanceof CompoundTag) {
                tag = (CompoundTag)entry.getValue();
                break;
            }
            throw new ChunkStoreException("CompoundTag expected for 'Level'; got " + ((Tag)entry.getValue()).getClass().getName());
        }
        if (tag == null) {
            throw new ChunkStoreException("Missing root 'Level' tag");
        }
        int dataVersion = rootTag.getInt("DataVersion");
        if (dataVersion >= 1519) {
            return new AnvilChunk13(tag);
        }
        Object tags = tag.getValue();
        if (tags.containsKey("Sections")) {
            return new AnvilChunk(world, tag);
        }
        return new OldChunk(world, tag);
    }

    @Override
    public void close() throws IOException {
    }

    public abstract boolean isValid();
}

