/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.ExpandCommandsRegistration;
import com.sk89q.worldedit.command.util.Logging;
import com.sk89q.worldedit.command.util.PermissionCondition;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.annotation.MultiDirection;
import com.sk89q.worldedit.internal.annotation.VertHeight;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.internal.command.CommandUtil;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.World;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandManagerService;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.part.ArgAcceptingCommandPart;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandPart;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.SubCommandPart;

@CommandContainer
public class ExpandCommands {
    public static void register(CommandRegistrationHandler registration, CommandManager commandManager, CommandManagerService commandManagerService) {
        CommandManager collect = commandManagerService.newCommandManager();
        registration.register(collect, ExpandCommandsRegistration.builder(), new ExpandCommands());
        org.enginehub.piston.Command expandBaseCommand = (org.enginehub.piston.Command)collect.getCommand("/expand").orElseThrow(() -> new IllegalStateException("No /expand command"));
        commandManager.register("/expand", command -> {
            command.condition((Command.Condition)new PermissionCondition((Set<String>)ImmutableSet.of((Object)"worldedit.selection.expand")));
            command.addPart((CommandPart)SubCommandPart.builder((TranslatableComponent)TranslatableComponent.of((String)"vert"), (Component)TextComponent.of((String)"Vertical expansion sub-command")).withCommands((Collection)ImmutableSet.of((Object)ExpandCommands.createVertCommand(commandManager))).optional().build());
            command.addParts((Iterable)expandBaseCommand.getParts());
            command.action(expandBaseCommand.getAction());
            command.description(expandBaseCommand.getDescription());
        });
    }

    private static org.enginehub.piston.Command createVertCommand(CommandManager commandManager) {
        CommandArgument heightPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"height"), (Component)TextComponent.of((String)"The height to expand both upwards and downwards")).defaultsTo((Iterable)ImmutableList.of((Object)"default-vertical-height")).build();
        return commandManager.newCommand("vert").addPart((CommandPart)heightPart).description((Component)TranslatableComponent.of((String)"worldedit.expand.description.vert")).action(parameters -> {
            int height = (Integer)Objects.requireNonNull(parameters.valueOf((ArgAcceptingCommandPart)heightPart).asSingle(Key.of(Integer.TYPE, VertHeight.class)));
            ExpandCommands.expandVert((LocalSession)CommandUtil.requireIV(Key.of(LocalSession.class), "localSession", (InjectedValueAccess)parameters), (Actor)CommandUtil.requireIV(Key.of(Actor.class), "actor", (InjectedValueAccess)parameters), (World)CommandUtil.requireIV(Key.of(World.class), "world", (InjectedValueAccess)parameters), height);
            return 1;
        }).build();
    }

    private static void expandVert(LocalSession session, Actor actor, World world, int height) throws IncompleteRegionException {
        Region region = session.getSelection(world);
        try {
            long oldSize = region.getVolume();
            region.expand(BlockVector3.at(0, height, 0), BlockVector3.at(0, -height, 0));
            session.getRegionSelector(world).learnChanges();
            long newSize = region.getVolume();
            session.getRegionSelector(world).explainRegionAdjust(actor, session);
            long changeSize = newSize - oldSize;
            actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.expand.expanded.vert", (Component[])new Component[]{TextComponent.of((long)changeSize)}));
        }
        catch (RegionOperationException e) {
            actor.printError((Component)TextComponent.of((String)e.getMessage()));
        }
    }

    @Command(name="/expand", desc="Expand the selection area")
    @Logging(value=Logging.LogMode.REGION)
    public void expand(Actor actor, World world, LocalSession session, @Arg(desc="Amount to expand the selection by, can be `vert` to expand to the whole vertical column") int amount, @Arg(desc="Amount to expand the selection by in the other direction", def={"0"}) int reverseAmount, @MultiDirection @Arg(desc="Direction to expand", def={"me"}) List<BlockVector3> direction) throws WorldEditException {
        Region region = session.getSelection(world);
        long oldSize = region.getVolume();
        if (reverseAmount == 0) {
            for (BlockVector3 dir : direction) {
                region.expand(dir.multiply(amount));
            }
        } else {
            for (BlockVector3 dir : direction) {
                region.expand(dir.multiply(amount), dir.multiply(-reverseAmount));
            }
        }
        session.getRegionSelector(world).learnChanges();
        long newSize = region.getVolume();
        session.getRegionSelector(world).explainRegionAdjust(actor, session);
        long changeSize = newSize - oldSize;
        actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.expand.expanded", (Component[])new Component[]{TextComponent.of((long)changeSize)}));
    }
}

