/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.command.util.HookMode;
import com.sk89q.worldedit.command.util.WorldEditAsyncCommandBuilder;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.input.DisallowedUsageException;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.util.formatting.component.PaginationBox;
import com.sk89q.worldedit.util.formatting.component.SideEffectBox;
import com.sk89q.worldedit.util.formatting.text.BuildableComponent;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.item.ItemType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.annotation.param.Switch;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class GeneralCommands {
    private final WorldEdit worldEdit;

    public GeneralCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(name="/limit", desc="Modify block change limit")
    @CommandPermissions(value={"worldedit.limit"})
    public void limit(Actor actor, LocalSession session, @Arg(desc="The limit to set", def={""}) Integer limit) {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        boolean mayDisable = actor.hasPermission("worldedit.limit.unrestricted");
        limit = limit == null ? config.defaultChangeLimit : Math.max(-1, limit);
        if (!mayDisable && config.maxChangeLimit > -1 && limit > config.maxChangeLimit) {
            actor.printError((Component)TranslatableComponent.of((String)"worldedit.limit.too-high", (Component[])new Component[]{TextComponent.of((int)config.maxChangeLimit)}));
            return;
        }
        session.setBlockChangeLimit(limit);
        Component component = TextComponent.empty().append((Component)TranslatableComponent.of((String)"worldedit.limit.set", (Component[])new Component[]{TextComponent.of((int)limit)}));
        if (limit != config.defaultChangeLimit) {
            component.append((Component)TextComponent.space()).append((Component)TranslatableComponent.of((String)"worldedit.limit.return-to-default", (TextColor)TextColor.GRAY));
        }
        actor.printInfo(component);
    }

    @Command(name="/timeout", desc="Modify evaluation timeout time.")
    @CommandPermissions(value={"worldedit.timeout"})
    public void timeout(Actor actor, LocalSession session, @Arg(desc="The timeout time to set", def={""}) Integer limit) {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        boolean mayDisable = actor.hasPermission("worldedit.timeout.unrestricted");
        limit = limit == null ? config.calculationTimeout : Math.max(-1, limit);
        if (!mayDisable && config.maxCalculationTimeout > -1 && limit > config.maxCalculationTimeout) {
            actor.printError((Component)TranslatableComponent.of((String)"worldedit.timeout.too-high", (Component[])new Component[]{TextComponent.of((int)config.maxCalculationTimeout)}));
            return;
        }
        session.setTimeout(limit);
        Component component = TextComponent.empty().append((Component)TranslatableComponent.of((String)"worldedit.timeout.set", (Component[])new Component[]{TextComponent.of((int)limit)}));
        if (limit != config.calculationTimeout) {
            component.append((Component)TranslatableComponent.of((String)"worldedit.timeout.return-to-default", (TextColor)TextColor.GRAY));
        }
        actor.printInfo(component);
    }

    @Command(name="/fast", desc="Toggle fast mode side effects")
    @CommandPermissions(value={"worldedit.fast"})
    public void fast(Actor actor, LocalSession session, @Arg(desc="The side effect", def={""}) SideEffect sideEffect, @Arg(desc="The new side effect state", def={""}) SideEffect.State newState, @Switch(name=104, desc="Show the info box") boolean showInfoBox) throws WorldEditException {
        if (sideEffect != null) {
            SideEffect.State currentState = session.getSideEffectSet().getState(sideEffect);
            if (newState != null && newState == currentState) {
                if (!showInfoBox) {
                    actor.printError((Component)TranslatableComponent.of((String)"worldedit.fast.sideeffect.already-set", (Component[])new Component[]{TranslatableComponent.of((String)sideEffect.getDisplayName()), TranslatableComponent.of((String)newState.getDisplayName())}));
                }
                return;
            }
            if (newState != null) {
                session.setSideEffectSet(session.getSideEffectSet().with(sideEffect, newState));
                if (!showInfoBox) {
                    actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.fast.sideeffect.set", (Component[])new Component[]{TranslatableComponent.of((String)sideEffect.getDisplayName()), TranslatableComponent.of((String)newState.getDisplayName())}));
                }
            } else {
                actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.fast.sideeffect.get", (Component[])new Component[]{TranslatableComponent.of((String)sideEffect.getDisplayName()), TranslatableComponent.of((String)currentState.getDisplayName())}));
            }
        } else if (newState != null) {
            SideEffectSet applier = session.getSideEffectSet();
            for (SideEffect sideEffectEntry : SideEffect.values()) {
                applier = applier.with(sideEffectEntry, newState);
            }
            session.setSideEffectSet(applier);
            if (!showInfoBox) {
                actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.fast.sideeffect.set-all", (Component[])new Component[]{TranslatableComponent.of((String)newState.getDisplayName())}));
            }
        }
        if (sideEffect == null || showInfoBox) {
            SideEffectBox sideEffectBox = new SideEffectBox(session.getSideEffectSet());
            actor.print(sideEffectBox.create(1));
        }
    }

    @Command(name="/reorder", desc="Sets the reorder mode of WorldEdit")
    @CommandPermissions(value={"worldedit.reorder"})
    public void reorderMode(Actor actor, LocalSession session, @Arg(desc="The reorder mode", def={""}) EditSession.ReorderMode reorderMode) {
        if (reorderMode == null) {
            actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.reorder.current", (Component[])new Component[]{TextComponent.of((String)session.getReorderMode().getDisplayName())}));
        } else {
            session.setReorderMode(reorderMode);
            actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.reorder.set", (Component[])new Component[]{TextComponent.of((String)session.getReorderMode().getDisplayName())}));
        }
    }

    @Command(name="/drawsel", desc="Toggle drawing the current selection")
    @CommandPermissions(value={"worldedit.drawsel"})
    public void drawSelection(Player player, LocalSession session, @Arg(desc="The new draw selection state", def={""}) Boolean drawSelection) throws WorldEditException {
        if (!WorldEdit.getInstance().getConfiguration().serverSideCUI) {
            throw new DisallowedUsageException("This functionality is disabled in the configuration!");
        }
        boolean useServerCui = session.shouldUseServerCUI();
        if (drawSelection != null && drawSelection == useServerCui) {
            player.printError((Component)TranslatableComponent.of((String)("worldedit.drawsel." + (useServerCui ? "enabled" : "disabled") + ".already")));
            return;
        }
        if (useServerCui) {
            session.setUseServerCUI(false);
            session.updateServerCUI(player);
            player.printInfo((Component)TranslatableComponent.of((String)"worldedit.drawsel.disabled"));
        } else {
            session.setUseServerCUI(true);
            session.updateServerCUI(player);
            player.printInfo((Component)TranslatableComponent.of((String)"worldedit.drawsel.enabled"));
        }
    }

    @Command(name="/world", desc="Sets the world override")
    @CommandPermissions(value={"worldedit.world"})
    public void world(Actor actor, LocalSession session, @Arg(desc="The world override", def={""}) World world) {
        session.setWorldOverride(world);
        if (world == null) {
            actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.world.remove"));
        } else {
            actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.world.set", (Component[])new Component[]{TextComponent.of((String)world.getId())}));
        }
    }

    @Command(name="/watchdog", desc="Changes watchdog hook state.", descFooter="This is dependent on platform implementation. Not all platforms support watchdog hooks, or contain a watchdog.")
    @CommandPermissions(value={"worldedit.watchdog"})
    public void watchdog(Actor actor, LocalSession session, @Arg(desc="The mode to set the watchdog hook to", def={""}) HookMode hookMode) {
        if (WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getWatchdog() == null) {
            actor.printError((Component)TranslatableComponent.of((String)"worldedit.watchdog.no-hook"));
            return;
        }
        boolean previousMode = session.isTickingWatchdog();
        if (hookMode != null && hookMode == HookMode.ACTIVE == previousMode) {
            actor.printError((Component)TranslatableComponent.of((String)(previousMode ? "worldedit.watchdog.active.already" : "worldedit.watchdog.inactive.already")));
            return;
        }
        session.setTickingWatchdog(!previousMode);
        actor.printInfo((Component)TranslatableComponent.of((String)(previousMode ? "worldedit.watchdog.inactive" : "worldedit.watchdog.active")));
    }

    @Command(name="gmask", aliases={"/gmask"}, desc="Set the global mask")
    @CommandPermissions(value={"worldedit.global-mask"})
    public void gmask(Actor actor, LocalSession session, @Arg(desc="The mask to set", def={""}) Mask mask) {
        if (mask == null) {
            session.setMask(null);
            actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.gmask.disabled"));
        } else {
            session.setMask(mask);
            actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.gmask.set"));
        }
    }

    @Command(name="toggleplace", aliases={"/toggleplace"}, desc="Switch between your position and pos1 for placement")
    public void togglePlace(Player player, LocalSession session) {
        if (session.togglePlacementPosition()) {
            player.printInfo((Component)TranslatableComponent.of((String)"worldedit.toggleplace.pos1"));
        } else {
            player.printInfo((Component)TranslatableComponent.of((String)"worldedit.toggleplace.player"));
        }
    }

    @Command(name="searchitem", aliases={"/searchitem", "/l", "/search"}, desc="Search for an item")
    @CommandPermissions(value={"worldedit.searchitem"})
    public void searchItem(Actor actor, @Switch(name=98, desc="Only search for blocks") boolean blocksOnly, @Switch(name=105, desc="Only search for items") boolean itemsOnly, @ArgFlag(name=112, desc="Page of results to return", def={"1"}) int page, @Arg(desc="Search query", variable=true) List<String> query) {
        String search = String.join((CharSequence)" ", query);
        if (search.length() <= 2) {
            actor.printError((Component)TranslatableComponent.of((String)"worldedit.searchitem.too-short"));
            return;
        }
        if (blocksOnly && itemsOnly) {
            actor.printError((Component)TranslatableComponent.of((String)"worldedit.searchitem.either-b-or-i"));
            return;
        }
        WorldEditAsyncCommandBuilder.createAndSendMessage(actor, (Callable<Component>)new ItemSearcher(search, blocksOnly, itemsOnly, page), (Component)TranslatableComponent.of((String)"worldedit.searchitem.searching"));
    }

    private static class ItemSearcher
    implements Callable<Component> {
        private final boolean blocksOnly;
        private final boolean itemsOnly;
        private final String search;
        private final int page;

        ItemSearcher(String search, boolean blocksOnly, boolean itemsOnly, int page) {
            this.blocksOnly = blocksOnly;
            this.itemsOnly = itemsOnly;
            this.search = search;
            this.page = page;
        }

        @Override
        public Component call() throws Exception {
            String command = "/searchitem " + (this.blocksOnly ? "-b " : "") + (this.itemsOnly ? "-i " : "") + "-p %page% " + this.search;
            TreeMap<String, BuildableComponent> results = new TreeMap<String, BuildableComponent>();
            String idMatch = this.search.replace(' ', '_');
            String nameMatch = this.search.toLowerCase(Locale.ROOT);
            for (ItemType searchType : ItemType.REGISTRY) {
                String id;
                if (this.blocksOnly && !searchType.hasBlockType() || this.itemsOnly && searchType.hasBlockType() || !(id = searchType.getId()).contains(idMatch)) continue;
                Component name = searchType.getRichName();
                results.put(id, ((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().append(name)).append(" (" + id + ")")).build());
            }
            ArrayList<Component> list = new ArrayList<Component>(results.values());
            return PaginationBox.fromComponents("Search results for '" + this.search + "'", command, list).create(this.page);
        }
    }
}

