/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.GeneralCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.command.util.HookMode;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.World;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class GeneralCommandsRegistration
implements CommandRegistration<GeneralCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<SideEffect> sideEffect_Key = Key.of(SideEffect.class);
    private static final Key<SideEffect.State> state_Key = Key.of(SideEffect.State.class);
    private static final Key<EditSession.ReorderMode> reorderMode_Key = Key.of(EditSession.ReorderMode.class);
    private static final Key<Boolean> boolean_Key = Key.of(Boolean.class);
    private static final Key<World> world_Key = Key.of(World.class);
    private static final Key<HookMode> hookMode_Key = Key.of(HookMode.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private CommandManager commandManager;
    private GeneralCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument limitPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"limit"), (Component)TextComponent.of((String)"The limit to set")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument limitPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"limit"), (Component)TextComponent.of((String)"The timeout time to set")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument sideEffectPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"sideEffect"), (Component)TextComponent.of((String)"The side effect")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(sideEffect_Key)).build();
    private final CommandArgument newStatePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"newState"), (Component)TextComponent.of((String)"The new side effect state")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(state_Key)).build();
    private final NoArgCommandFlag showInfoBoxPart = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Show the info box")).build();
    private final CommandArgument reorderModePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"reorderMode"), (Component)TextComponent.of((String)"The reorder mode")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(reorderMode_Key)).build();
    private final CommandArgument drawSelectionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"drawSelection"), (Component)TextComponent.of((String)"The new draw selection state")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(boolean_Key)).build();
    private final CommandArgument worldPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"world"), (Component)TextComponent.of((String)"The world override")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(world_Key)).build();
    private final CommandArgument hookModePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"hookMode"), (Component)TextComponent.of((String)"The mode to set the watchdog hook to")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(hookMode_Key)).build();
    private final CommandArgument maskPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mask"), (Component)TextComponent.of((String)"The mask to set")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final NoArgCommandFlag blocksOnlyPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Only search for blocks")).build();
    private final NoArgCommandFlag itemsOnlyPart = CommandParts.flag((char)'i', (Component)TextComponent.of((String)"Only search for items")).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Page of results to return")).withRequiredArg().argNamed(TranslatableComponent.of((String)"page")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument queryPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"query"), (Component)TextComponent.of((String)"Search query")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).variable(true).build();

    private GeneralCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static GeneralCommandsRegistration builder() {
        return new GeneralCommandsRegistration();
    }

    public GeneralCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public GeneralCommandsRegistration containerInstance(GeneralCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public GeneralCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public GeneralCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("/limit", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Modify block change limit"));
            b.parts((Collection)ImmutableList.of((Object)this.limitPart));
            b.action(this::cmd$_limit);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"limit", (Class[])new Class[]{Actor.class, LocalSession.class, Integer.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/timeout", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Modify evaluation timeout time."));
            b.parts((Collection)ImmutableList.of((Object)this.limitPart2));
            b.action(this::cmd$_timeout);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"timeout", (Class[])new Class[]{Actor.class, LocalSession.class, Integer.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/fast", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Toggle fast mode side effects"));
            b.parts((Collection)ImmutableList.of((Object)this.sideEffectPart, (Object)this.newStatePart, (Object)this.showInfoBoxPart));
            b.action(this::cmd$_fast);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"fast", (Class[])new Class[]{Actor.class, LocalSession.class, SideEffect.class, SideEffect.State.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/reorder", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Sets the reorder mode of WorldEdit"));
            b.parts((Collection)ImmutableList.of((Object)this.reorderModePart));
            b.action(this::cmd$_reorder);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"reorderMode", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.ReorderMode.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/drawsel", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Toggle drawing the current selection"));
            b.parts((Collection)ImmutableList.of((Object)this.drawSelectionPart));
            b.action(this::cmd$_drawsel);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"drawSelection", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/world", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Sets the world override"));
            b.parts((Collection)ImmutableList.of((Object)this.worldPart));
            b.action(this::cmd$_world);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"world", (Class[])new Class[]{Actor.class, LocalSession.class, World.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/watchdog", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Changes watchdog hook state."));
            b.footer((Component)TextComponent.of((String)"This is dependent on platform implementation. Not all platforms support watchdog hooks, or contain a watchdog."));
            b.parts((Collection)ImmutableList.of((Object)this.hookModePart));
            b.action(this::cmd$_watchdog);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"watchdog", (Class[])new Class[]{Actor.class, LocalSession.class, HookMode.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("gmask", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/gmask"));
            b.description((Component)TextComponent.of((String)"Set the global mask"));
            b.parts((Collection)ImmutableList.of((Object)this.maskPart));
            b.action(this::cmd$gmask);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"gmask", (Class[])new Class[]{Actor.class, LocalSession.class, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("toggleplace", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/toggleplace"));
            b.description((Component)TextComponent.of((String)"Switch between your position and pos1 for placement"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$toggleplace);
        });
        this.commandManager.register("searchitem", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/searchitem", (Object)"/l", (Object)"/search"));
            b.description((Component)TextComponent.of((String)"Search for an item"));
            b.parts((Collection)ImmutableList.of((Object)this.blocksOnlyPart, (Object)this.itemsOnlyPart, (Object)this.pagePart, (Object)this.queryPart));
            b.action(this::cmd$searchitem);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"searchItem", (Class[])new Class[]{Actor.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$_limit(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"limit", (Class[])new Class[]{Actor.class, LocalSession.class, Integer.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.limit(this.extract$actor(parameters), this.extract$session(parameters), this.extract$limit(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_timeout(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"timeout", (Class[])new Class[]{Actor.class, LocalSession.class, Integer.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.timeout(this.extract$actor(parameters), this.extract$session(parameters), this.extract$limit2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_fast(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"fast", (Class[])new Class[]{Actor.class, LocalSession.class, SideEffect.class, SideEffect.State.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.fast(this.extract$actor(parameters), this.extract$session(parameters), this.extract$sideEffect(parameters), this.extract$newState(parameters), this.extract$showInfoBox(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_reorder(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"reorderMode", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.ReorderMode.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.reorderMode(this.extract$actor(parameters), this.extract$session(parameters), this.extract$reorderMode(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_drawsel(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"drawSelection", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.drawSelection(this.extract$player(parameters), this.extract$session(parameters), this.extract$drawSelection(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_world(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"world", (Class[])new Class[]{Actor.class, LocalSession.class, World.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.world(this.extract$actor(parameters), this.extract$session(parameters), this.extract$world(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_watchdog(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"watchdog", (Class[])new Class[]{Actor.class, LocalSession.class, HookMode.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.watchdog(this.extract$actor(parameters), this.extract$session(parameters), this.extract$hookMode(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$gmask(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"gmask", (Class[])new Class[]{Actor.class, LocalSession.class, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.gmask(this.extract$actor(parameters), this.extract$session(parameters), this.extract$mask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$toggleplace(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"togglePlace", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.togglePlace(this.extract$player(parameters), this.extract$session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$searchitem(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"searchItem", (Class[])new Class[]{Actor.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.searchItem(this.extract$actor(parameters), this.extract$blocksOnly(parameters), this.extract$itemsOnly(parameters), this.extract$page(parameters), this.extract$query(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private LocalSession extract$session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private Integer extract$limit(CommandParameters parameters) {
        return (Integer)this.limitPart.value(parameters).asSingle(integer_Key);
    }

    private Integer extract$limit2(CommandParameters parameters) {
        return (Integer)this.limitPart2.value(parameters).asSingle(integer_Key);
    }

    private SideEffect extract$sideEffect(CommandParameters parameters) {
        return (SideEffect)((Object)this.sideEffectPart.value(parameters).asSingle(sideEffect_Key));
    }

    private SideEffect.State extract$newState(CommandParameters parameters) {
        return (SideEffect.State)((Object)this.newStatePart.value(parameters).asSingle(state_Key));
    }

    private boolean extract$showInfoBox(CommandParameters parameters) {
        return this.showInfoBoxPart.in(parameters);
    }

    private EditSession.ReorderMode extract$reorderMode(CommandParameters parameters) {
        return (EditSession.ReorderMode)((Object)this.reorderModePart.value(parameters).asSingle(reorderMode_Key));
    }

    private Player extract$player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private Boolean extract$drawSelection(CommandParameters parameters) {
        return (Boolean)this.drawSelectionPart.value(parameters).asSingle(boolean_Key);
    }

    private World extract$world(CommandParameters parameters) {
        return (World)this.worldPart.value(parameters).asSingle(world_Key);
    }

    private HookMode extract$hookMode(CommandParameters parameters) {
        return (HookMode)((Object)this.hookModePart.value(parameters).asSingle(hookMode_Key));
    }

    private Mask extract$mask(CommandParameters parameters) {
        return (Mask)this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private boolean extract$blocksOnly(CommandParameters parameters) {
        return this.blocksOnlyPart.in(parameters);
    }

    private boolean extract$itemsOnly(CommandParameters parameters) {
        return this.itemsOnlyPart.in(parameters);
    }

    private int extract$page(CommandParameters parameters) {
        return (Integer)this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private List<String> extract$query(CommandParameters parameters) {
        return this.queryPart.value(parameters).asMultiple(string_Key);
    }
}

